/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.publicca.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExternalAccountKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_EXTERNAL_ACCOUNT_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/externalAccountKeys/{external_account_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String externalAccountKey;

    @Deprecated
    protected ExternalAccountKeyName() {
        this.project = null;
        this.location = null;
        this.externalAccountKey = null;
    }

    private ExternalAccountKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.externalAccountKey = (String)Preconditions.checkNotNull((Object)builder.getExternalAccountKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExternalAccountKey() {
        return this.externalAccountKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExternalAccountKeyName of(String project, String location, String externalAccountKey) {
        return ExternalAccountKeyName.newBuilder().setProject(project).setLocation(location).setExternalAccountKey(externalAccountKey).build();
    }

    public static String format(String project, String location, String externalAccountKey) {
        return ExternalAccountKeyName.newBuilder().setProject(project).setLocation(location).setExternalAccountKey(externalAccountKey).build().toString();
    }

    public static ExternalAccountKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_EXTERNAL_ACCOUNT_KEY.validatedMatch(formattedString, "ExternalAccountKeyName.parse: formattedString not in valid format");
        return ExternalAccountKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("external_account_key"));
    }

    public static List<ExternalAccountKeyName> parseList(List<String> formattedStrings) {
        ArrayList<ExternalAccountKeyName> list = new ArrayList<ExternalAccountKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExternalAccountKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExternalAccountKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExternalAccountKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_EXTERNAL_ACCOUNT_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExternalAccountKeyName externalAccountKeyName = this;
            synchronized (externalAccountKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.externalAccountKey != null) {
                        fieldMapBuilder.put((Object)"external_account_key", (Object)this.externalAccountKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_EXTERNAL_ACCOUNT_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "external_account_key", this.externalAccountKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ExternalAccountKeyName that = (ExternalAccountKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.externalAccountKey, that.externalAccountKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.externalAccountKey);
    }

    public static class Builder {
        private String project;
        private String location;
        private String externalAccountKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getExternalAccountKey() {
            return this.externalAccountKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setExternalAccountKey(String externalAccountKey) {
            this.externalAccountKey = externalAccountKey;
            return this;
        }

        private Builder(ExternalAccountKeyName externalAccountKeyName) {
            this.project = externalAccountKeyName.project;
            this.location = externalAccountKeyName.location;
            this.externalAccountKey = externalAccountKeyName.externalAccountKey;
        }

        public ExternalAccountKeyName build() {
            return new ExternalAccountKeyName(this);
        }
    }
}

