/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privatecatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VersionName
implements ResourceName {
    private static final PathTemplate CATALOG_PRODUCT_VERSION = PathTemplate.createWithoutUrlEncoding((String)"catalogs/{catalog}/products/{product}/versions/{version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String catalog;
    private final String product;
    private final String version;

    @Deprecated
    protected VersionName() {
        this.catalog = null;
        this.product = null;
        this.version = null;
    }

    private VersionName(Builder builder) {
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.product = (String)Preconditions.checkNotNull((Object)builder.getProduct());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VersionName of(String catalog, String product, String version) {
        return VersionName.newBuilder().setCatalog(catalog).setProduct(product).setVersion(version).build();
    }

    public static String format(String catalog, String product, String version) {
        return VersionName.newBuilder().setCatalog(catalog).setProduct(product).setVersion(version).build().toString();
    }

    public static VersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CATALOG_PRODUCT_VERSION.validatedMatch(formattedString, "VersionName.parse: formattedString not in valid format");
        return VersionName.of((String)matchMap.get("catalog"), (String)matchMap.get("product"), (String)matchMap.get("version"));
    }

    public static List<VersionName> parseList(List<String> formattedStrings) {
        ArrayList<VersionName> list = new ArrayList<VersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CATALOG_PRODUCT_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VersionName versionName = this;
            synchronized (versionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.product != null) {
                        fieldMapBuilder.put((Object)"product", (Object)this.product);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CATALOG_PRODUCT_VERSION.instantiate(new String[]{"catalog", this.catalog, "product", this.product, "version", this.version});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            VersionName that = (VersionName)o;
            return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.product, that.product) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        h ^= Objects.hashCode(this.product);
        h *= 1000003;
        return h ^= Objects.hashCode(this.version);
    }

    public static class Builder {
        private String catalog;
        private String product;
        private String version;

        protected Builder() {
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getProduct() {
            return this.product;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setProduct(String product) {
            this.product = product;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        private Builder(VersionName versionName) {
            this.catalog = versionName.catalog;
            this.product = versionName.product;
            this.version = versionName.version;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }
}

