/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrgPolicyViolationsPreviewName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/orgPolicyViolationsPreviews/{org_policy_violations_preview}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String orgPolicyViolationsPreview;

    @Deprecated
    protected OrgPolicyViolationsPreviewName() {
        this.organization = null;
        this.location = null;
        this.orgPolicyViolationsPreview = null;
    }

    private OrgPolicyViolationsPreviewName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.orgPolicyViolationsPreview = (String)Preconditions.checkNotNull((Object)builder.getOrgPolicyViolationsPreview());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrgPolicyViolationsPreview() {
        return this.orgPolicyViolationsPreview;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrgPolicyViolationsPreviewName of(String organization, String location, String orgPolicyViolationsPreview) {
        return OrgPolicyViolationsPreviewName.newBuilder().setOrganization(organization).setLocation(location).setOrgPolicyViolationsPreview(orgPolicyViolationsPreview).build();
    }

    public static String format(String organization, String location, String orgPolicyViolationsPreview) {
        return OrgPolicyViolationsPreviewName.newBuilder().setOrganization(organization).setLocation(location).setOrgPolicyViolationsPreview(orgPolicyViolationsPreview).build().toString();
    }

    public static OrgPolicyViolationsPreviewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW.validatedMatch(formattedString, "OrgPolicyViolationsPreviewName.parse: formattedString not in valid format");
        return OrgPolicyViolationsPreviewName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("org_policy_violations_preview"));
    }

    public static List<OrgPolicyViolationsPreviewName> parseList(List<String> formattedStrings) {
        ArrayList<OrgPolicyViolationsPreviewName> list = new ArrayList<OrgPolicyViolationsPreviewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrgPolicyViolationsPreviewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrgPolicyViolationsPreviewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrgPolicyViolationsPreviewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrgPolicyViolationsPreviewName orgPolicyViolationsPreviewName = this;
            synchronized (orgPolicyViolationsPreviewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.orgPolicyViolationsPreview != null) {
                        fieldMapBuilder.put((Object)"org_policy_violations_preview", (Object)this.orgPolicyViolationsPreview);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW.instantiate(new String[]{"organization", this.organization, "location", this.location, "org_policy_violations_preview", this.orgPolicyViolationsPreview});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrgPolicyViolationsPreviewName that = (OrgPolicyViolationsPreviewName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.orgPolicyViolationsPreview, that.orgPolicyViolationsPreview);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.orgPolicyViolationsPreview);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String orgPolicyViolationsPreview;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrgPolicyViolationsPreview() {
            return this.orgPolicyViolationsPreview;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrgPolicyViolationsPreview(String orgPolicyViolationsPreview) {
            this.orgPolicyViolationsPreview = orgPolicyViolationsPreview;
            return this;
        }

        private Builder(OrgPolicyViolationsPreviewName orgPolicyViolationsPreviewName) {
            this.organization = orgPolicyViolationsPreviewName.organization;
            this.location = orgPolicyViolationsPreviewName.location;
            this.orgPolicyViolationsPreview = orgPolicyViolationsPreviewName.orgPolicyViolationsPreview;
        }

        public OrgPolicyViolationsPreviewName build() {
            return new OrgPolicyViolationsPreviewName(this);
        }
    }
}

