/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OrgPolicyViolationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW_ORG_POLICY_VIOLATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/orgPolicyViolationsPreviews/{org_policy_violations_preview}/orgPolicyViolations/{org_policy_violation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String orgPolicyViolationsPreview;
    private final String orgPolicyViolation;

    @Deprecated
    protected OrgPolicyViolationName() {
        this.organization = null;
        this.location = null;
        this.orgPolicyViolationsPreview = null;
        this.orgPolicyViolation = null;
    }

    private OrgPolicyViolationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.orgPolicyViolationsPreview = (String)Preconditions.checkNotNull((Object)builder.getOrgPolicyViolationsPreview());
        this.orgPolicyViolation = (String)Preconditions.checkNotNull((Object)builder.getOrgPolicyViolation());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrgPolicyViolationsPreview() {
        return this.orgPolicyViolationsPreview;
    }

    public String getOrgPolicyViolation() {
        return this.orgPolicyViolation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OrgPolicyViolationName of(String organization, String location, String orgPolicyViolationsPreview, String orgPolicyViolation) {
        return OrgPolicyViolationName.newBuilder().setOrganization(organization).setLocation(location).setOrgPolicyViolationsPreview(orgPolicyViolationsPreview).setOrgPolicyViolation(orgPolicyViolation).build();
    }

    public static String format(String organization, String location, String orgPolicyViolationsPreview, String orgPolicyViolation) {
        return OrgPolicyViolationName.newBuilder().setOrganization(organization).setLocation(location).setOrgPolicyViolationsPreview(orgPolicyViolationsPreview).setOrgPolicyViolation(orgPolicyViolation).build().toString();
    }

    public static OrgPolicyViolationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW_ORG_POLICY_VIOLATION.validatedMatch(formattedString, "OrgPolicyViolationName.parse: formattedString not in valid format");
        return OrgPolicyViolationName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("org_policy_violations_preview"), (String)matchMap.get("org_policy_violation"));
    }

    public static List<OrgPolicyViolationName> parseList(List<String> formattedStrings) {
        ArrayList<OrgPolicyViolationName> list = new ArrayList<OrgPolicyViolationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OrgPolicyViolationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OrgPolicyViolationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OrgPolicyViolationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW_ORG_POLICY_VIOLATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OrgPolicyViolationName orgPolicyViolationName = this;
            synchronized (orgPolicyViolationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.orgPolicyViolationsPreview != null) {
                        fieldMapBuilder.put((Object)"org_policy_violations_preview", (Object)this.orgPolicyViolationsPreview);
                    }
                    if (this.orgPolicyViolation != null) {
                        fieldMapBuilder.put((Object)"org_policy_violation", (Object)this.orgPolicyViolation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_ORG_POLICY_VIOLATIONS_PREVIEW_ORG_POLICY_VIOLATION.instantiate(new String[]{"organization", this.organization, "location", this.location, "org_policy_violations_preview", this.orgPolicyViolationsPreview, "org_policy_violation", this.orgPolicyViolation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            OrgPolicyViolationName that = (OrgPolicyViolationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.orgPolicyViolationsPreview, that.orgPolicyViolationsPreview) && Objects.equals(this.orgPolicyViolation, that.orgPolicyViolation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.orgPolicyViolationsPreview);
        h *= 1000003;
        return h ^= Objects.hashCode(this.orgPolicyViolation);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String orgPolicyViolationsPreview;
        private String orgPolicyViolation;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrgPolicyViolationsPreview() {
            return this.orgPolicyViolationsPreview;
        }

        public String getOrgPolicyViolation() {
            return this.orgPolicyViolation;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrgPolicyViolationsPreview(String orgPolicyViolationsPreview) {
            this.orgPolicyViolationsPreview = orgPolicyViolationsPreview;
            return this;
        }

        public Builder setOrgPolicyViolation(String orgPolicyViolation) {
            this.orgPolicyViolation = orgPolicyViolation;
            return this;
        }

        private Builder(OrgPolicyViolationName orgPolicyViolationName) {
            this.organization = orgPolicyViolationName.organization;
            this.location = orgPolicyViolationName.location;
            this.orgPolicyViolationsPreview = orgPolicyViolationName.orgPolicyViolationsPreview;
            this.orgPolicyViolation = orgPolicyViolationName.orgPolicyViolation;
        }

        public OrgPolicyViolationName build() {
            return new OrgPolicyViolationName(this);
        }
    }
}

