/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.policysimulator.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReplayName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPLAY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/replays/{replay}");
    private static final PathTemplate FOLDER_LOCATION_REPLAY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/replays/{replay}");
    private static final PathTemplate ORGANIZATION_LOCATION_REPLAY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/replays/{replay}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String replay;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ReplayName() {
        this.project = null;
        this.location = null;
        this.replay = null;
        this.folder = null;
        this.organization = null;
    }

    private ReplayName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.replay = (String)Preconditions.checkNotNull((Object)builder.getReplay());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_REPLAY;
    }

    private ReplayName(FolderLocationReplayBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.replay = (String)Preconditions.checkNotNull((Object)builder.getReplay());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_REPLAY;
    }

    private ReplayName(OrganizationLocationReplayBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.replay = (String)Preconditions.checkNotNull((Object)builder.getReplay());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_REPLAY;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReplay() {
        return this.replay;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectLocationReplayBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderLocationReplayBuilder newFolderLocationReplayBuilder() {
        return new FolderLocationReplayBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationLocationReplayBuilder newOrganizationLocationReplayBuilder() {
        return new OrganizationLocationReplayBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReplayName of(String project, String location, String replay) {
        return ReplayName.newBuilder().setProject(project).setLocation(location).setReplay(replay).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ReplayName ofProjectLocationReplayName(String project, String location, String replay) {
        return ReplayName.newBuilder().setProject(project).setLocation(location).setReplay(replay).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ReplayName ofFolderLocationReplayName(String folder, String location, String replay) {
        return ReplayName.newFolderLocationReplayBuilder().setFolder(folder).setLocation(location).setReplay(replay).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ReplayName ofOrganizationLocationReplayName(String organization, String location, String replay) {
        return ReplayName.newOrganizationLocationReplayBuilder().setOrganization(organization).setLocation(location).setReplay(replay).build();
    }

    public static String format(String project, String location, String replay) {
        return ReplayName.newBuilder().setProject(project).setLocation(location).setReplay(replay).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationReplayName(String project, String location, String replay) {
        return ReplayName.newBuilder().setProject(project).setLocation(location).setReplay(replay).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderLocationReplayName(String folder, String location, String replay) {
        return ReplayName.newFolderLocationReplayBuilder().setFolder(folder).setLocation(location).setReplay(replay).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationLocationReplayName(String organization, String location, String replay) {
        return ReplayName.newOrganizationLocationReplayBuilder().setOrganization(organization).setLocation(location).setReplay(replay).build().toString();
    }

    public static ReplayName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_REPLAY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_REPLAY.match(formattedString);
            return ReplayName.ofProjectLocationReplayName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("replay"));
        }
        if (FOLDER_LOCATION_REPLAY.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_REPLAY.match(formattedString);
            return ReplayName.ofFolderLocationReplayName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("replay"));
        }
        if (ORGANIZATION_LOCATION_REPLAY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_REPLAY.match(formattedString);
            return ReplayName.ofOrganizationLocationReplayName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("replay"));
        }
        throw new ValidationException("ReplayName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ReplayName> parseList(List<String> formattedStrings) {
        ArrayList<ReplayName> list = new ArrayList<ReplayName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReplayName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReplayName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReplayName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPLAY.matches(formattedString) || FOLDER_LOCATION_REPLAY.matches(formattedString) || ORGANIZATION_LOCATION_REPLAY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReplayName replayName = this;
            synchronized (replayName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.replay != null) {
                        fieldMapBuilder.put((Object)"replay", (Object)this.replay);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReplayName that = (ReplayName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.replay, that.replay) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.replay);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationLocationReplayBuilder {
        private String organization;
        private String location;
        private String replay;

        protected OrganizationLocationReplayBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReplay() {
            return this.replay;
        }

        public OrganizationLocationReplayBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationReplayBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationReplayBuilder setReplay(String replay) {
            this.replay = replay;
            return this;
        }

        public ReplayName build() {
            return new ReplayName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderLocationReplayBuilder {
        private String folder;
        private String location;
        private String replay;

        protected FolderLocationReplayBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReplay() {
            return this.replay;
        }

        public FolderLocationReplayBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationReplayBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationReplayBuilder setReplay(String replay) {
            this.replay = replay;
            return this;
        }

        public ReplayName build() {
            return new ReplayName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String replay;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReplay() {
            return this.replay;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReplay(String replay) {
            this.replay = replay;
            return this;
        }

        private Builder(ReplayName replayName) {
            Preconditions.checkArgument((boolean)Objects.equals(replayName.pathTemplate, PROJECT_LOCATION_REPLAY), (Object)"toBuilder is only supported when ReplayName has the pattern of projects/{project}/locations/{location}/replays/{replay}");
            this.project = replayName.project;
            this.location = replayName.location;
            this.replay = replayName.replay;
        }

        public ReplayName build() {
            return new ReplayName(this);
        }
    }
}

