/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParameterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PARAMETER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/parameters/{parameter}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String parameter;

    @Deprecated
    protected ParameterName() {
        this.project = null;
        this.location = null;
        this.parameter = null;
    }

    private ParameterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.parameter = (String)Preconditions.checkNotNull((Object)builder.getParameter());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParameter() {
        return this.parameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ParameterName of(String project, String location, String parameter) {
        return ParameterName.newBuilder().setProject(project).setLocation(location).setParameter(parameter).build();
    }

    public static String format(String project, String location, String parameter) {
        return ParameterName.newBuilder().setProject(project).setLocation(location).setParameter(parameter).build().toString();
    }

    public static ParameterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PARAMETER.validatedMatch(formattedString, "ParameterName.parse: formattedString not in valid format");
        return ParameterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("parameter"));
    }

    public static List<ParameterName> parseList(List<String> formattedStrings) {
        ArrayList<ParameterName> list = new ArrayList<ParameterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ParameterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ParameterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ParameterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PARAMETER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ParameterName parameterName = this;
            synchronized (parameterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.parameter != null) {
                        fieldMapBuilder.put((Object)"parameter", (Object)this.parameter);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PARAMETER.instantiate(new String[]{"project", this.project, "location", this.location, "parameter", this.parameter});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ParameterName that = (ParameterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.parameter, that.parameter);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.parameter);
    }

    public static class Builder {
        private String project;
        private String location;
        private String parameter;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getParameter() {
            return this.parameter;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setParameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        private Builder(ParameterName parameterName) {
            this.project = parameterName.project;
            this.location = parameterName.location;
            this.parameter = parameterName.parameter;
        }

        public ParameterName build() {
            return new ParameterName(this);
        }
    }
}

