/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oslogin.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"users/{user}");
    private final String user;

    public String getUser() {
        return this.user;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private UserName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
    }

    public static UserName of(String user) {
        return UserName.newBuilder().setUser(user).build();
    }

    public static String format(String user) {
        return UserName.newBuilder().setUser(user).build().toString();
    }

    public static UserName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "UserName.parse: formattedString not in valid format");
        return UserName.of((String)matchMap.get("user"));
    }

    public static List<UserName> parseList(List<String> formattedStrings) {
        ArrayList<UserName> list = new ArrayList<UserName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UserName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"user", this.user});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UserName) {
            UserName that = (UserName)o;
            return this.user.equals(that.user);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.user.hashCode();
    }

    public static class Builder {
        private String user;

        public String getUser() {
            return this.user;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        private Builder() {
        }

        private Builder(UserName userName) {
            this.user = userName.user;
        }

        public UserName build() {
            return new UserName(this);
        }
    }
}

