/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PatchJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/patchJobs/{patch_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String patchJob;

    public String getProject() {
        return this.project;
    }

    public String getPatchJob() {
        return this.patchJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PatchJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.patchJob = (String)Preconditions.checkNotNull((Object)builder.getPatchJob());
    }

    public static PatchJobName of(String project, String patchJob) {
        return PatchJobName.newBuilder().setProject(project).setPatchJob(patchJob).build();
    }

    public static String format(String project, String patchJob) {
        return PatchJobName.newBuilder().setProject(project).setPatchJob(patchJob).build().toString();
    }

    public static PatchJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "PatchJobName.parse: formattedString not in valid format");
        return PatchJobName.of((String)matchMap.get("project"), (String)matchMap.get("patch_job"));
    }

    public static List<PatchJobName> parseList(List<String> formattedStrings) {
        ArrayList<PatchJobName> list = new ArrayList<PatchJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PatchJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PatchJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PatchJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PatchJobName patchJobName = this;
            synchronized (patchJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"patchJob", (Object)this.patchJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "patch_job", this.patchJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PatchJobName) {
            PatchJobName that = (PatchJobName)o;
            return this.project.equals(that.project) && this.patchJob.equals(that.patchJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.patchJob.hashCode();
    }

    public static class Builder {
        private String project;
        private String patchJob;

        public String getProject() {
            return this.project;
        }

        public String getPatchJob() {
            return this.patchJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setPatchJob(String patchJob) {
            this.patchJob = patchJob;
            return this;
        }

        private Builder() {
        }

        private Builder(PatchJobName patchJobName) {
            this.project = patchJobName.project;
            this.patchJob = patchJobName.patchJob;
        }

        public PatchJobName build() {
            return new PatchJobName(this);
        }
    }
}

