/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PatchDeploymentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/patchDeployments/{patch_deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String patchDeployment;

    public String getProject() {
        return this.project;
    }

    public String getPatchDeployment() {
        return this.patchDeployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private PatchDeploymentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.patchDeployment = (String)Preconditions.checkNotNull((Object)builder.getPatchDeployment());
    }

    public static PatchDeploymentName of(String project, String patchDeployment) {
        return PatchDeploymentName.newBuilder().setProject(project).setPatchDeployment(patchDeployment).build();
    }

    public static String format(String project, String patchDeployment) {
        return PatchDeploymentName.newBuilder().setProject(project).setPatchDeployment(patchDeployment).build().toString();
    }

    public static PatchDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "PatchDeploymentName.parse: formattedString not in valid format");
        return PatchDeploymentName.of((String)matchMap.get("project"), (String)matchMap.get("patch_deployment"));
    }

    public static List<PatchDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<PatchDeploymentName> list = new ArrayList<PatchDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PatchDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PatchDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PatchDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PatchDeploymentName patchDeploymentName = this;
            synchronized (patchDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"patchDeployment", (Object)this.patchDeployment);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "patch_deployment", this.patchDeployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PatchDeploymentName) {
            PatchDeploymentName that = (PatchDeploymentName)o;
            return this.project.equals(that.project) && this.patchDeployment.equals(that.patchDeployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.patchDeployment.hashCode();
    }

    public static class Builder {
        private String project;
        private String patchDeployment;

        public String getProject() {
            return this.project;
        }

        public String getPatchDeployment() {
            return this.patchDeployment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setPatchDeployment(String patchDeployment) {
            this.patchDeployment = patchDeployment;
            return this;
        }

        private Builder() {
        }

        private Builder(PatchDeploymentName patchDeploymentName) {
            this.project = patchDeploymentName.project;
            this.patchDeployment = patchDeploymentName.patchDeployment;
        }

        public PatchDeploymentName build() {
            return new PatchDeploymentName(this);
        }
    }
}

