/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orgpolicy.v2;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConstraintName
implements ResourceName {
    private static final PathTemplate PROJECT_CONSTRAINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/constraints/{constraint}");
    private static final PathTemplate FOLDER_CONSTRAINT = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/constraints/{constraint}");
    private static final PathTemplate ORGANIZATION_CONSTRAINT = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/constraints/{constraint}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String constraint;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ConstraintName() {
        this.project = null;
        this.constraint = null;
        this.folder = null;
        this.organization = null;
    }

    private ConstraintName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.constraint = (String)Preconditions.checkNotNull((Object)builder.getConstraint());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_CONSTRAINT;
    }

    private ConstraintName(FolderConstraintBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.constraint = (String)Preconditions.checkNotNull((Object)builder.getConstraint());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_CONSTRAINT;
    }

    private ConstraintName(OrganizationConstraintBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.constraint = (String)Preconditions.checkNotNull((Object)builder.getConstraint());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_CONSTRAINT;
    }

    public String getProject() {
        return this.project;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectConstraintBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderConstraintBuilder newFolderConstraintBuilder() {
        return new FolderConstraintBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationConstraintBuilder newOrganizationConstraintBuilder() {
        return new OrganizationConstraintBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConstraintName of(String project, String constraint) {
        return ConstraintName.newBuilder().setProject(project).setConstraint(constraint).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConstraintName ofProjectConstraintName(String project, String constraint) {
        return ConstraintName.newBuilder().setProject(project).setConstraint(constraint).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConstraintName ofFolderConstraintName(String folder, String constraint) {
        return ConstraintName.newFolderConstraintBuilder().setFolder(folder).setConstraint(constraint).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConstraintName ofOrganizationConstraintName(String organization, String constraint) {
        return ConstraintName.newOrganizationConstraintBuilder().setOrganization(organization).setConstraint(constraint).build();
    }

    public static String format(String project, String constraint) {
        return ConstraintName.newBuilder().setProject(project).setConstraint(constraint).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConstraintName(String project, String constraint) {
        return ConstraintName.newBuilder().setProject(project).setConstraint(constraint).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderConstraintName(String folder, String constraint) {
        return ConstraintName.newFolderConstraintBuilder().setFolder(folder).setConstraint(constraint).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationConstraintName(String organization, String constraint) {
        return ConstraintName.newOrganizationConstraintBuilder().setOrganization(organization).setConstraint(constraint).build().toString();
    }

    public static ConstraintName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONSTRAINT.matches(formattedString)) {
            Map matchMap = PROJECT_CONSTRAINT.match(formattedString);
            return ConstraintName.ofProjectConstraintName((String)matchMap.get("project"), (String)matchMap.get("constraint"));
        }
        if (FOLDER_CONSTRAINT.matches(formattedString)) {
            Map matchMap = FOLDER_CONSTRAINT.match(formattedString);
            return ConstraintName.ofFolderConstraintName((String)matchMap.get("folder"), (String)matchMap.get("constraint"));
        }
        if (ORGANIZATION_CONSTRAINT.matches(formattedString)) {
            Map matchMap = ORGANIZATION_CONSTRAINT.match(formattedString);
            return ConstraintName.ofOrganizationConstraintName((String)matchMap.get("organization"), (String)matchMap.get("constraint"));
        }
        throw new ValidationException("ConstraintName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConstraintName> parseList(List<String> formattedStrings) {
        ArrayList<ConstraintName> list = new ArrayList<ConstraintName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConstraintName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConstraintName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConstraintName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONSTRAINT.matches(formattedString) || FOLDER_CONSTRAINT.matches(formattedString) || ORGANIZATION_CONSTRAINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConstraintName constraintName = this;
            synchronized (constraintName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.constraint != null) {
                        fieldMapBuilder.put((Object)"constraint", (Object)this.constraint);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConstraintName that = (ConstraintName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.constraint, that.constraint) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.constraint);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationConstraintBuilder {
        private String organization;
        private String constraint;

        protected OrganizationConstraintBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getConstraint() {
            return this.constraint;
        }

        public OrganizationConstraintBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationConstraintBuilder setConstraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        public ConstraintName build() {
            return new ConstraintName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderConstraintBuilder {
        private String folder;
        private String constraint;

        protected FolderConstraintBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getConstraint() {
            return this.constraint;
        }

        public FolderConstraintBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderConstraintBuilder setConstraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        public ConstraintName build() {
            return new ConstraintName(this);
        }
    }

    public static class Builder {
        private String project;
        private String constraint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConstraint() {
            return this.constraint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConstraint(String constraint) {
            this.constraint = constraint;
            return this;
        }

        private Builder(ConstraintName constraintName) {
            Preconditions.checkArgument((boolean)Objects.equals(constraintName.pathTemplate, PROJECT_CONSTRAINT), (Object)"toBuilder is only supported when ConstraintName has the pattern of projects/{project}/constraints/{constraint}");
            this.project = constraintName.project;
            this.constraint = constraintName.constraint;
        }

        public ConstraintName build() {
            return new ConstraintName(this);
        }
    }
}

