/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserWorkloadsConfigMapName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_CONFIG_MAP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/environments/{environment}/userWorkloadsConfigMaps/{user_workloads_config_map}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String environment;
    private final String userWorkloadsConfigMap;

    @Deprecated
    protected UserWorkloadsConfigMapName() {
        this.project = null;
        this.location = null;
        this.environment = null;
        this.userWorkloadsConfigMap = null;
    }

    private UserWorkloadsConfigMapName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.environment = (String)Preconditions.checkNotNull((Object)builder.getEnvironment());
        this.userWorkloadsConfigMap = (String)Preconditions.checkNotNull((Object)builder.getUserWorkloadsConfigMap());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getUserWorkloadsConfigMap() {
        return this.userWorkloadsConfigMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserWorkloadsConfigMapName of(String project, String location, String environment, String userWorkloadsConfigMap) {
        return UserWorkloadsConfigMapName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUserWorkloadsConfigMap(userWorkloadsConfigMap).build();
    }

    public static String format(String project, String location, String environment, String userWorkloadsConfigMap) {
        return UserWorkloadsConfigMapName.newBuilder().setProject(project).setLocation(location).setEnvironment(environment).setUserWorkloadsConfigMap(userWorkloadsConfigMap).build().toString();
    }

    public static UserWorkloadsConfigMapName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_CONFIG_MAP.validatedMatch(formattedString, "UserWorkloadsConfigMapName.parse: formattedString not in valid format");
        return UserWorkloadsConfigMapName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("environment"), (String)matchMap.get("user_workloads_config_map"));
    }

    public static List<UserWorkloadsConfigMapName> parseList(List<String> formattedStrings) {
        ArrayList<UserWorkloadsConfigMapName> list = new ArrayList<UserWorkloadsConfigMapName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserWorkloadsConfigMapName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserWorkloadsConfigMapName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserWorkloadsConfigMapName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_CONFIG_MAP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserWorkloadsConfigMapName userWorkloadsConfigMapName = this;
            synchronized (userWorkloadsConfigMapName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.environment != null) {
                        fieldMapBuilder.put((Object)"environment", (Object)this.environment);
                    }
                    if (this.userWorkloadsConfigMap != null) {
                        fieldMapBuilder.put((Object)"user_workloads_config_map", (Object)this.userWorkloadsConfigMap);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENVIRONMENT_USER_WORKLOADS_CONFIG_MAP.instantiate(new String[]{"project", this.project, "location", this.location, "environment", this.environment, "user_workloads_config_map", this.userWorkloadsConfigMap});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserWorkloadsConfigMapName that = (UserWorkloadsConfigMapName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.environment, that.environment) && Objects.equals(this.userWorkloadsConfigMap, that.userWorkloadsConfigMap);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.environment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userWorkloadsConfigMap);
    }

    public static class Builder {
        private String project;
        private String location;
        private String environment;
        private String userWorkloadsConfigMap;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getUserWorkloadsConfigMap() {
            return this.userWorkloadsConfigMap;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        public Builder setUserWorkloadsConfigMap(String userWorkloadsConfigMap) {
            this.userWorkloadsConfigMap = userWorkloadsConfigMap;
            return this;
        }

        private Builder(UserWorkloadsConfigMapName userWorkloadsConfigMapName) {
            this.project = userWorkloadsConfigMapName.project;
            this.location = userWorkloadsConfigMapName.location;
            this.environment = userWorkloadsConfigMapName.environment;
            this.userWorkloadsConfigMap = userWorkloadsConfigMapName.userWorkloadsConfigMap;
        }

        public UserWorkloadsConfigMapName build() {
            return new UserWorkloadsConfigMapName(this);
        }
    }
}

