/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EntitlementName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENTITLEMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/entitlements/{entitlement}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String entitlement;

    @Deprecated
    protected EntitlementName() {
        this.project = null;
        this.location = null;
        this.entitlement = null;
    }

    private EntitlementName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.entitlement = (String)Preconditions.checkNotNull((Object)builder.getEntitlement());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EntitlementName of(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build();
    }

    public static String format(String project, String location, String entitlement) {
        return EntitlementName.newBuilder().setProject(project).setLocation(location).setEntitlement(entitlement).build().toString();
    }

    public static EntitlementName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENTITLEMENT.validatedMatch(formattedString, "EntitlementName.parse: formattedString not in valid format");
        return EntitlementName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("entitlement"));
    }

    public static List<EntitlementName> parseList(List<String> formattedStrings) {
        ArrayList<EntitlementName> list = new ArrayList<EntitlementName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EntitlementName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EntitlementName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EntitlementName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENTITLEMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EntitlementName entitlementName = this;
            synchronized (entitlementName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.entitlement != null) {
                        fieldMapBuilder.put((Object)"entitlement", (Object)this.entitlement);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENTITLEMENT.instantiate(new String[]{"project", this.project, "location", this.location, "entitlement", this.entitlement});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EntitlementName that = (EntitlementName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.entitlement, that.entitlement);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.entitlement);
    }

    public static class Builder {
        private String project;
        private String location;
        private String entitlement;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEntitlement() {
            return this.entitlement;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEntitlement(String entitlement) {
            this.entitlement = entitlement;
            return this;
        }

        private Builder(EntitlementName entitlementName) {
            this.project = entitlementName.project;
            this.location = entitlementName.location;
            this.entitlement = entitlementName.entitlement;
        }

        public EntitlementName build() {
            return new EntitlementName(this);
        }
    }
}

