/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutonomousDbVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTONOMOUS_DB_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/autonomousDbVersions/{autonomous_db_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String autonomousDbVersion;

    @Deprecated
    protected AutonomousDbVersionName() {
        this.project = null;
        this.location = null;
        this.autonomousDbVersion = null;
    }

    private AutonomousDbVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.autonomousDbVersion = (String)Preconditions.checkNotNull((Object)builder.getAutonomousDbVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAutonomousDbVersion() {
        return this.autonomousDbVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutonomousDbVersionName of(String project, String location, String autonomousDbVersion) {
        return AutonomousDbVersionName.newBuilder().setProject(project).setLocation(location).setAutonomousDbVersion(autonomousDbVersion).build();
    }

    public static String format(String project, String location, String autonomousDbVersion) {
        return AutonomousDbVersionName.newBuilder().setProject(project).setLocation(location).setAutonomousDbVersion(autonomousDbVersion).build().toString();
    }

    public static AutonomousDbVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AUTONOMOUS_DB_VERSION.validatedMatch(formattedString, "AutonomousDbVersionName.parse: formattedString not in valid format");
        return AutonomousDbVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("autonomous_db_version"));
    }

    public static List<AutonomousDbVersionName> parseList(List<String> formattedStrings) {
        ArrayList<AutonomousDbVersionName> list = new ArrayList<AutonomousDbVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutonomousDbVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutonomousDbVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutonomousDbVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTONOMOUS_DB_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutonomousDbVersionName autonomousDbVersionName = this;
            synchronized (autonomousDbVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.autonomousDbVersion != null) {
                        fieldMapBuilder.put((Object)"autonomous_db_version", (Object)this.autonomousDbVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AUTONOMOUS_DB_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "autonomous_db_version", this.autonomousDbVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutonomousDbVersionName that = (AutonomousDbVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.autonomousDbVersion, that.autonomousDbVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.autonomousDbVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String autonomousDbVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAutonomousDbVersion() {
            return this.autonomousDbVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAutonomousDbVersion(String autonomousDbVersion) {
            this.autonomousDbVersion = autonomousDbVersion;
            return this;
        }

        private Builder(AutonomousDbVersionName autonomousDbVersionName) {
            this.project = autonomousDbVersionName.project;
            this.location = autonomousDbVersionName.location;
            this.autonomousDbVersion = autonomousDbVersionName.autonomousDbVersion;
        }

        public AutonomousDbVersionName build() {
            return new AutonomousDbVersionName(this);
        }
    }
}

