/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DbServerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE_DB_SERVER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}/dbServers/{db_server}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudExadataInfrastructure;
    private final String dbServer;

    @Deprecated
    protected DbServerName() {
        this.project = null;
        this.location = null;
        this.cloudExadataInfrastructure = null;
        this.dbServer = null;
    }

    private DbServerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudExadataInfrastructure = (String)Preconditions.checkNotNull((Object)builder.getCloudExadataInfrastructure());
        this.dbServer = (String)Preconditions.checkNotNull((Object)builder.getDbServer());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudExadataInfrastructure() {
        return this.cloudExadataInfrastructure;
    }

    public String getDbServer() {
        return this.dbServer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DbServerName of(String project, String location, String cloudExadataInfrastructure, String dbServer) {
        return DbServerName.newBuilder().setProject(project).setLocation(location).setCloudExadataInfrastructure(cloudExadataInfrastructure).setDbServer(dbServer).build();
    }

    public static String format(String project, String location, String cloudExadataInfrastructure, String dbServer) {
        return DbServerName.newBuilder().setProject(project).setLocation(location).setCloudExadataInfrastructure(cloudExadataInfrastructure).setDbServer(dbServer).build().toString();
    }

    public static DbServerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE_DB_SERVER.validatedMatch(formattedString, "DbServerName.parse: formattedString not in valid format");
        return DbServerName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_exadata_infrastructure"), (String)matchMap.get("db_server"));
    }

    public static List<DbServerName> parseList(List<String> formattedStrings) {
        ArrayList<DbServerName> list = new ArrayList<DbServerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DbServerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DbServerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DbServerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE_DB_SERVER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DbServerName dbServerName = this;
            synchronized (dbServerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudExadataInfrastructure != null) {
                        fieldMapBuilder.put((Object)"cloud_exadata_infrastructure", (Object)this.cloudExadataInfrastructure);
                    }
                    if (this.dbServer != null) {
                        fieldMapBuilder.put((Object)"db_server", (Object)this.dbServer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE_DB_SERVER.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_exadata_infrastructure", this.cloudExadataInfrastructure, "db_server", this.dbServer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DbServerName that = (DbServerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudExadataInfrastructure, that.cloudExadataInfrastructure) && Objects.equals(this.dbServer, that.dbServer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cloudExadataInfrastructure);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dbServer);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudExadataInfrastructure;
        private String dbServer;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudExadataInfrastructure() {
            return this.cloudExadataInfrastructure;
        }

        public String getDbServer() {
            return this.dbServer;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudExadataInfrastructure(String cloudExadataInfrastructure) {
            this.cloudExadataInfrastructure = cloudExadataInfrastructure;
            return this;
        }

        public Builder setDbServer(String dbServer) {
            this.dbServer = dbServer;
            return this;
        }

        private Builder(DbServerName dbServerName) {
            this.project = dbServerName.project;
            this.location = dbServerName.location;
            this.cloudExadataInfrastructure = dbServerName.cloudExadataInfrastructure;
            this.dbServer = dbServerName.dbServer;
        }

        public DbServerName build() {
            return new DbServerName(this);
        }
    }
}

