/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudVmClusterName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_VM_CLUSTER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudVmCluster;

    @Deprecated
    protected CloudVmClusterName() {
        this.project = null;
        this.location = null;
        this.cloudVmCluster = null;
    }

    private CloudVmClusterName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudVmCluster = (String)Preconditions.checkNotNull((Object)builder.getCloudVmCluster());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudVmCluster() {
        return this.cloudVmCluster;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudVmClusterName of(String project, String location, String cloudVmCluster) {
        return CloudVmClusterName.newBuilder().setProject(project).setLocation(location).setCloudVmCluster(cloudVmCluster).build();
    }

    public static String format(String project, String location, String cloudVmCluster) {
        return CloudVmClusterName.newBuilder().setProject(project).setLocation(location).setCloudVmCluster(cloudVmCluster).build().toString();
    }

    public static CloudVmClusterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_VM_CLUSTER.validatedMatch(formattedString, "CloudVmClusterName.parse: formattedString not in valid format");
        return CloudVmClusterName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_vm_cluster"));
    }

    public static List<CloudVmClusterName> parseList(List<String> formattedStrings) {
        ArrayList<CloudVmClusterName> list = new ArrayList<CloudVmClusterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudVmClusterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudVmClusterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudVmClusterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_VM_CLUSTER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudVmClusterName cloudVmClusterName = this;
            synchronized (cloudVmClusterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudVmCluster != null) {
                        fieldMapBuilder.put((Object)"cloud_vm_cluster", (Object)this.cloudVmCluster);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_VM_CLUSTER.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_vm_cluster", this.cloudVmCluster});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudVmClusterName that = (CloudVmClusterName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudVmCluster, that.cloudVmCluster);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudVmCluster);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudVmCluster;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudVmCluster() {
            return this.cloudVmCluster;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudVmCluster(String cloudVmCluster) {
            this.cloudVmCluster = cloudVmCluster;
            return this;
        }

        private Builder(CloudVmClusterName cloudVmClusterName) {
            this.project = cloudVmClusterName.project;
            this.location = cloudVmClusterName.location;
            this.cloudVmCluster = cloudVmClusterName.cloudVmCluster;
        }

        public CloudVmClusterName build() {
            return new CloudVmClusterName(this);
        }
    }
}

