/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutonomousDatabaseCharacterSetName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTONOMOUS_DATABASE_CHARACTER_SET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/autonomousDatabaseCharacterSets/{autonomous_database_character_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String autonomousDatabaseCharacterSet;

    @Deprecated
    protected AutonomousDatabaseCharacterSetName() {
        this.project = null;
        this.location = null;
        this.autonomousDatabaseCharacterSet = null;
    }

    private AutonomousDatabaseCharacterSetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.autonomousDatabaseCharacterSet = (String)Preconditions.checkNotNull((Object)builder.getAutonomousDatabaseCharacterSet());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAutonomousDatabaseCharacterSet() {
        return this.autonomousDatabaseCharacterSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutonomousDatabaseCharacterSetName of(String project, String location, String autonomousDatabaseCharacterSet) {
        return AutonomousDatabaseCharacterSetName.newBuilder().setProject(project).setLocation(location).setAutonomousDatabaseCharacterSet(autonomousDatabaseCharacterSet).build();
    }

    public static String format(String project, String location, String autonomousDatabaseCharacterSet) {
        return AutonomousDatabaseCharacterSetName.newBuilder().setProject(project).setLocation(location).setAutonomousDatabaseCharacterSet(autonomousDatabaseCharacterSet).build().toString();
    }

    public static AutonomousDatabaseCharacterSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AUTONOMOUS_DATABASE_CHARACTER_SET.validatedMatch(formattedString, "AutonomousDatabaseCharacterSetName.parse: formattedString not in valid format");
        return AutonomousDatabaseCharacterSetName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("autonomous_database_character_set"));
    }

    public static List<AutonomousDatabaseCharacterSetName> parseList(List<String> formattedStrings) {
        ArrayList<AutonomousDatabaseCharacterSetName> list = new ArrayList<AutonomousDatabaseCharacterSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutonomousDatabaseCharacterSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutonomousDatabaseCharacterSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutonomousDatabaseCharacterSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTONOMOUS_DATABASE_CHARACTER_SET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutonomousDatabaseCharacterSetName autonomousDatabaseCharacterSetName = this;
            synchronized (autonomousDatabaseCharacterSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.autonomousDatabaseCharacterSet != null) {
                        fieldMapBuilder.put((Object)"autonomous_database_character_set", (Object)this.autonomousDatabaseCharacterSet);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AUTONOMOUS_DATABASE_CHARACTER_SET.instantiate(new String[]{"project", this.project, "location", this.location, "autonomous_database_character_set", this.autonomousDatabaseCharacterSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutonomousDatabaseCharacterSetName that = (AutonomousDatabaseCharacterSetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.autonomousDatabaseCharacterSet, that.autonomousDatabaseCharacterSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.autonomousDatabaseCharacterSet);
    }

    public static class Builder {
        private String project;
        private String location;
        private String autonomousDatabaseCharacterSet;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAutonomousDatabaseCharacterSet() {
            return this.autonomousDatabaseCharacterSet;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAutonomousDatabaseCharacterSet(String autonomousDatabaseCharacterSet) {
            this.autonomousDatabaseCharacterSet = autonomousDatabaseCharacterSet;
            return this;
        }

        private Builder(AutonomousDatabaseCharacterSetName autonomousDatabaseCharacterSetName) {
            this.project = autonomousDatabaseCharacterSetName.project;
            this.location = autonomousDatabaseCharacterSetName.location;
            this.autonomousDatabaseCharacterSet = autonomousDatabaseCharacterSetName.autonomousDatabaseCharacterSet;
        }

        public AutonomousDatabaseCharacterSetName build() {
            return new AutonomousDatabaseCharacterSetName(this);
        }
    }
}

