/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GiVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GI_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/giVersions/{gi_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String giVersion;

    @Deprecated
    protected GiVersionName() {
        this.project = null;
        this.location = null;
        this.giVersion = null;
    }

    private GiVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.giVersion = (String)Preconditions.checkNotNull((Object)builder.getGiVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGiVersion() {
        return this.giVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GiVersionName of(String project, String location, String giVersion) {
        return GiVersionName.newBuilder().setProject(project).setLocation(location).setGiVersion(giVersion).build();
    }

    public static String format(String project, String location, String giVersion) {
        return GiVersionName.newBuilder().setProject(project).setLocation(location).setGiVersion(giVersion).build().toString();
    }

    public static GiVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GI_VERSION.validatedMatch(formattedString, "GiVersionName.parse: formattedString not in valid format");
        return GiVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("gi_version"));
    }

    public static List<GiVersionName> parseList(List<String> formattedStrings) {
        ArrayList<GiVersionName> list = new ArrayList<GiVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GiVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GiVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GiVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GI_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GiVersionName giVersionName = this;
            synchronized (giVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.giVersion != null) {
                        fieldMapBuilder.put((Object)"gi_version", (Object)this.giVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GI_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "gi_version", this.giVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GiVersionName that = (GiVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.giVersion, that.giVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.giVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String giVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGiVersion() {
            return this.giVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGiVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        private Builder(GiVersionName giVersionName) {
            this.project = giVersionName.project;
            this.location = giVersionName.location;
            this.giVersion = giVersionName.giVersion;
        }

        public GiVersionName build() {
            return new GiVersionName(this);
        }
    }
}

