/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DbSystemShapeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DB_SYSTEM_SHAPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dbSystemShapes/{db_system_shape}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dbSystemShape;

    @Deprecated
    protected DbSystemShapeName() {
        this.project = null;
        this.location = null;
        this.dbSystemShape = null;
    }

    private DbSystemShapeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dbSystemShape = (String)Preconditions.checkNotNull((Object)builder.getDbSystemShape());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDbSystemShape() {
        return this.dbSystemShape;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DbSystemShapeName of(String project, String location, String dbSystemShape) {
        return DbSystemShapeName.newBuilder().setProject(project).setLocation(location).setDbSystemShape(dbSystemShape).build();
    }

    public static String format(String project, String location, String dbSystemShape) {
        return DbSystemShapeName.newBuilder().setProject(project).setLocation(location).setDbSystemShape(dbSystemShape).build().toString();
    }

    public static DbSystemShapeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DB_SYSTEM_SHAPE.validatedMatch(formattedString, "DbSystemShapeName.parse: formattedString not in valid format");
        return DbSystemShapeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("db_system_shape"));
    }

    public static List<DbSystemShapeName> parseList(List<String> formattedStrings) {
        ArrayList<DbSystemShapeName> list = new ArrayList<DbSystemShapeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DbSystemShapeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DbSystemShapeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DbSystemShapeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DB_SYSTEM_SHAPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DbSystemShapeName dbSystemShapeName = this;
            synchronized (dbSystemShapeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dbSystemShape != null) {
                        fieldMapBuilder.put((Object)"db_system_shape", (Object)this.dbSystemShape);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DB_SYSTEM_SHAPE.instantiate(new String[]{"project", this.project, "location", this.location, "db_system_shape", this.dbSystemShape});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DbSystemShapeName that = (DbSystemShapeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dbSystemShape, that.dbSystemShape);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dbSystemShape);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dbSystemShape;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDbSystemShape() {
            return this.dbSystemShape;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDbSystemShape(String dbSystemShape) {
            this.dbSystemShape = dbSystemShape;
            return this;
        }

        private Builder(DbSystemShapeName dbSystemShapeName) {
            this.project = dbSystemShapeName.project;
            this.location = dbSystemShapeName.location;
            this.dbSystemShape = dbSystemShapeName.dbSystemShape;
        }

        public DbSystemShapeName build() {
            return new DbSystemShapeName(this);
        }
    }
}

