/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DbNodeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_VM_CLUSTER_DB_NODE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}/dbNodes/{db_node}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudVmCluster;
    private final String dbNode;

    @Deprecated
    protected DbNodeName() {
        this.project = null;
        this.location = null;
        this.cloudVmCluster = null;
        this.dbNode = null;
    }

    private DbNodeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudVmCluster = (String)Preconditions.checkNotNull((Object)builder.getCloudVmCluster());
        this.dbNode = (String)Preconditions.checkNotNull((Object)builder.getDbNode());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudVmCluster() {
        return this.cloudVmCluster;
    }

    public String getDbNode() {
        return this.dbNode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DbNodeName of(String project, String location, String cloudVmCluster, String dbNode) {
        return DbNodeName.newBuilder().setProject(project).setLocation(location).setCloudVmCluster(cloudVmCluster).setDbNode(dbNode).build();
    }

    public static String format(String project, String location, String cloudVmCluster, String dbNode) {
        return DbNodeName.newBuilder().setProject(project).setLocation(location).setCloudVmCluster(cloudVmCluster).setDbNode(dbNode).build().toString();
    }

    public static DbNodeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_VM_CLUSTER_DB_NODE.validatedMatch(formattedString, "DbNodeName.parse: formattedString not in valid format");
        return DbNodeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_vm_cluster"), (String)matchMap.get("db_node"));
    }

    public static List<DbNodeName> parseList(List<String> formattedStrings) {
        ArrayList<DbNodeName> list = new ArrayList<DbNodeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DbNodeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DbNodeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DbNodeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_VM_CLUSTER_DB_NODE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DbNodeName dbNodeName = this;
            synchronized (dbNodeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudVmCluster != null) {
                        fieldMapBuilder.put((Object)"cloud_vm_cluster", (Object)this.cloudVmCluster);
                    }
                    if (this.dbNode != null) {
                        fieldMapBuilder.put((Object)"db_node", (Object)this.dbNode);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_VM_CLUSTER_DB_NODE.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_vm_cluster", this.cloudVmCluster, "db_node", this.dbNode});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DbNodeName that = (DbNodeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudVmCluster, that.cloudVmCluster) && Objects.equals(this.dbNode, that.dbNode);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.cloudVmCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dbNode);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudVmCluster;
        private String dbNode;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudVmCluster() {
            return this.cloudVmCluster;
        }

        public String getDbNode() {
            return this.dbNode;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudVmCluster(String cloudVmCluster) {
            this.cloudVmCluster = cloudVmCluster;
            return this;
        }

        public Builder setDbNode(String dbNode) {
            this.dbNode = dbNode;
            return this;
        }

        private Builder(DbNodeName dbNodeName) {
            this.project = dbNodeName.project;
            this.location = dbNodeName.location;
            this.cloudVmCluster = dbNodeName.cloudVmCluster;
            this.dbNode = dbNodeName.dbNode;
        }

        public DbNodeName build() {
            return new DbNodeName(this);
        }
    }
}

