/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudExadataInfrastructureName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String cloudExadataInfrastructure;

    @Deprecated
    protected CloudExadataInfrastructureName() {
        this.project = null;
        this.location = null;
        this.cloudExadataInfrastructure = null;
    }

    private CloudExadataInfrastructureName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudExadataInfrastructure = (String)Preconditions.checkNotNull((Object)builder.getCloudExadataInfrastructure());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudExadataInfrastructure() {
        return this.cloudExadataInfrastructure;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudExadataInfrastructureName of(String project, String location, String cloudExadataInfrastructure) {
        return CloudExadataInfrastructureName.newBuilder().setProject(project).setLocation(location).setCloudExadataInfrastructure(cloudExadataInfrastructure).build();
    }

    public static String format(String project, String location, String cloudExadataInfrastructure) {
        return CloudExadataInfrastructureName.newBuilder().setProject(project).setLocation(location).setCloudExadataInfrastructure(cloudExadataInfrastructure).build().toString();
    }

    public static CloudExadataInfrastructureName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE.validatedMatch(formattedString, "CloudExadataInfrastructureName.parse: formattedString not in valid format");
        return CloudExadataInfrastructureName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("cloud_exadata_infrastructure"));
    }

    public static List<CloudExadataInfrastructureName> parseList(List<String> formattedStrings) {
        ArrayList<CloudExadataInfrastructureName> list = new ArrayList<CloudExadataInfrastructureName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudExadataInfrastructureName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudExadataInfrastructureName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudExadataInfrastructureName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudExadataInfrastructureName cloudExadataInfrastructureName = this;
            synchronized (cloudExadataInfrastructureName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudExadataInfrastructure != null) {
                        fieldMapBuilder.put((Object)"cloud_exadata_infrastructure", (Object)this.cloudExadataInfrastructure);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLOUD_EXADATA_INFRASTRUCTURE.instantiate(new String[]{"project", this.project, "location", this.location, "cloud_exadata_infrastructure", this.cloudExadataInfrastructure});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudExadataInfrastructureName that = (CloudExadataInfrastructureName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudExadataInfrastructure, that.cloudExadataInfrastructure);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudExadataInfrastructure);
    }

    public static class Builder {
        private String project;
        private String location;
        private String cloudExadataInfrastructure;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudExadataInfrastructure() {
            return this.cloudExadataInfrastructure;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudExadataInfrastructure(String cloudExadataInfrastructure) {
            this.cloudExadataInfrastructure = cloudExadataInfrastructure;
            return this;
        }

        private Builder(CloudExadataInfrastructureName cloudExadataInfrastructureName) {
            this.project = cloudExadataInfrastructureName.project;
            this.location = cloudExadataInfrastructureName.location;
            this.cloudExadataInfrastructure = cloudExadataInfrastructureName.cloudExadataInfrastructure;
        }

        public CloudExadataInfrastructureName build() {
            return new CloudExadataInfrastructureName(this);
        }
    }
}

