/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.oracledatabase.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AutonomousDatabaseName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTONOMOUS_DATABASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String autonomousDatabase;

    @Deprecated
    protected AutonomousDatabaseName() {
        this.project = null;
        this.location = null;
        this.autonomousDatabase = null;
    }

    private AutonomousDatabaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.autonomousDatabase = (String)Preconditions.checkNotNull((Object)builder.getAutonomousDatabase());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAutonomousDatabase() {
        return this.autonomousDatabase;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AutonomousDatabaseName of(String project, String location, String autonomousDatabase) {
        return AutonomousDatabaseName.newBuilder().setProject(project).setLocation(location).setAutonomousDatabase(autonomousDatabase).build();
    }

    public static String format(String project, String location, String autonomousDatabase) {
        return AutonomousDatabaseName.newBuilder().setProject(project).setLocation(location).setAutonomousDatabase(autonomousDatabase).build().toString();
    }

    public static AutonomousDatabaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AUTONOMOUS_DATABASE.validatedMatch(formattedString, "AutonomousDatabaseName.parse: formattedString not in valid format");
        return AutonomousDatabaseName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("autonomous_database"));
    }

    public static List<AutonomousDatabaseName> parseList(List<String> formattedStrings) {
        ArrayList<AutonomousDatabaseName> list = new ArrayList<AutonomousDatabaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AutonomousDatabaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AutonomousDatabaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AutonomousDatabaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTONOMOUS_DATABASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AutonomousDatabaseName autonomousDatabaseName = this;
            synchronized (autonomousDatabaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.autonomousDatabase != null) {
                        fieldMapBuilder.put((Object)"autonomous_database", (Object)this.autonomousDatabase);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AUTONOMOUS_DATABASE.instantiate(new String[]{"project", this.project, "location", this.location, "autonomous_database", this.autonomousDatabase});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AutonomousDatabaseName that = (AutonomousDatabaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.autonomousDatabase, that.autonomousDatabase);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.autonomousDatabase);
    }

    public static class Builder {
        private String project;
        private String location;
        private String autonomousDatabase;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAutonomousDatabase() {
            return this.autonomousDatabase;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAutonomousDatabase(String autonomousDatabase) {
            this.autonomousDatabase = autonomousDatabase;
            return this;
        }

        private Builder(AutonomousDatabaseName autonomousDatabaseName) {
            this.project = autonomousDatabaseName.project;
            this.location = autonomousDatabaseName.location;
            this.autonomousDatabase = autonomousDatabaseName.autonomousDatabase;
        }

        public AutonomousDatabaseName build() {
            return new AutonomousDatabaseName(this);
        }
    }
}

