/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.optimization.v1;

import com.google.cloud.optimization.v1.FleetRoutingProto;
import com.google.cloud.optimization.v1.InjectedSolutionConstraint;
import com.google.cloud.optimization.v1.InjectedSolutionConstraintOrBuilder;
import com.google.cloud.optimization.v1.OptimizeToursRequestOrBuilder;
import com.google.cloud.optimization.v1.ShipmentModel;
import com.google.cloud.optimization.v1.ShipmentModelOrBuilder;
import com.google.cloud.optimization.v1.ShipmentRoute;
import com.google.cloud.optimization.v1.ShipmentRouteOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OptimizeToursRequest
extends GeneratedMessageV3
implements OptimizeToursRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile Object parent_ = "";
    public static final int TIMEOUT_FIELD_NUMBER = 2;
    private Duration timeout_;
    public static final int MODEL_FIELD_NUMBER = 3;
    private ShipmentModel model_;
    public static final int SOLVING_MODE_FIELD_NUMBER = 4;
    private int solvingMode_ = 0;
    public static final int MAX_VALIDATION_ERRORS_FIELD_NUMBER = 5;
    private int maxValidationErrors_ = 0;
    public static final int SEARCH_MODE_FIELD_NUMBER = 6;
    private int searchMode_ = 0;
    public static final int INJECTED_FIRST_SOLUTION_ROUTES_FIELD_NUMBER = 7;
    private List<ShipmentRoute> injectedFirstSolutionRoutes_;
    public static final int INJECTED_SOLUTION_CONSTRAINT_FIELD_NUMBER = 8;
    private InjectedSolutionConstraint injectedSolutionConstraint_;
    public static final int REFRESH_DETAILS_ROUTES_FIELD_NUMBER = 9;
    private List<ShipmentRoute> refreshDetailsRoutes_;
    public static final int INTERPRET_INJECTED_SOLUTIONS_USING_LABELS_FIELD_NUMBER = 10;
    private boolean interpretInjectedSolutionsUsingLabels_ = false;
    public static final int CONSIDER_ROAD_TRAFFIC_FIELD_NUMBER = 11;
    private boolean considerRoadTraffic_ = false;
    public static final int POPULATE_POLYLINES_FIELD_NUMBER = 12;
    private boolean populatePolylines_ = false;
    public static final int POPULATE_TRANSITION_POLYLINES_FIELD_NUMBER = 13;
    private boolean populateTransitionPolylines_ = false;
    public static final int ALLOW_LARGE_DEADLINE_DESPITE_INTERRUPTION_RISK_FIELD_NUMBER = 14;
    private boolean allowLargeDeadlineDespiteInterruptionRisk_ = false;
    public static final int USE_GEODESIC_DISTANCES_FIELD_NUMBER = 15;
    private boolean useGeodesicDistances_ = false;
    public static final int GEODESIC_METERS_PER_SECOND_FIELD_NUMBER = 16;
    private double geodesicMetersPerSecond_ = 0.0;
    public static final int LABEL_FIELD_NUMBER = 17;
    private volatile Object label_ = "";
    public static final int POPULATE_TRAVEL_STEP_POLYLINES_FIELD_NUMBER = 20;
    private boolean populateTravelStepPolylines_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final OptimizeToursRequest DEFAULT_INSTANCE = new OptimizeToursRequest();
    private static final Parser<OptimizeToursRequest> PARSER = new AbstractParser<OptimizeToursRequest>(){

        public OptimizeToursRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = OptimizeToursRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private OptimizeToursRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private OptimizeToursRequest() {
        this.parent_ = "";
        this.solvingMode_ = 0;
        this.searchMode_ = 0;
        this.injectedFirstSolutionRoutes_ = Collections.emptyList();
        this.refreshDetailsRoutes_ = Collections.emptyList();
        this.label_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new OptimizeToursRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FleetRoutingProto.internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FleetRoutingProto.internal_static_google_cloud_optimization_v1_OptimizeToursRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(OptimizeToursRequest.class, Builder.class);
    }

    @Override
    public String getParent() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.parent_ = s;
        return s;
    }

    @Override
    public ByteString getParentBytes() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.parent_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasTimeout() {
        return this.timeout_ != null;
    }

    @Override
    public Duration getTimeout() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public DurationOrBuilder getTimeoutOrBuilder() {
        return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
    }

    @Override
    public boolean hasModel() {
        return this.model_ != null;
    }

    @Override
    public ShipmentModel getModel() {
        return this.model_ == null ? ShipmentModel.getDefaultInstance() : this.model_;
    }

    @Override
    public ShipmentModelOrBuilder getModelOrBuilder() {
        return this.model_ == null ? ShipmentModel.getDefaultInstance() : this.model_;
    }

    @Override
    public int getSolvingModeValue() {
        return this.solvingMode_;
    }

    @Override
    public SolvingMode getSolvingMode() {
        SolvingMode result = SolvingMode.forNumber(this.solvingMode_);
        return result == null ? SolvingMode.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasMaxValidationErrors() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public int getMaxValidationErrors() {
        return this.maxValidationErrors_;
    }

    @Override
    public int getSearchModeValue() {
        return this.searchMode_;
    }

    @Override
    public SearchMode getSearchMode() {
        SearchMode result = SearchMode.forNumber(this.searchMode_);
        return result == null ? SearchMode.UNRECOGNIZED : result;
    }

    @Override
    public List<ShipmentRoute> getInjectedFirstSolutionRoutesList() {
        return this.injectedFirstSolutionRoutes_;
    }

    @Override
    public List<? extends ShipmentRouteOrBuilder> getInjectedFirstSolutionRoutesOrBuilderList() {
        return this.injectedFirstSolutionRoutes_;
    }

    @Override
    public int getInjectedFirstSolutionRoutesCount() {
        return this.injectedFirstSolutionRoutes_.size();
    }

    @Override
    public ShipmentRoute getInjectedFirstSolutionRoutes(int index) {
        return this.injectedFirstSolutionRoutes_.get(index);
    }

    @Override
    public ShipmentRouteOrBuilder getInjectedFirstSolutionRoutesOrBuilder(int index) {
        return this.injectedFirstSolutionRoutes_.get(index);
    }

    @Override
    public boolean hasInjectedSolutionConstraint() {
        return this.injectedSolutionConstraint_ != null;
    }

    @Override
    public InjectedSolutionConstraint getInjectedSolutionConstraint() {
        return this.injectedSolutionConstraint_ == null ? InjectedSolutionConstraint.getDefaultInstance() : this.injectedSolutionConstraint_;
    }

    @Override
    public InjectedSolutionConstraintOrBuilder getInjectedSolutionConstraintOrBuilder() {
        return this.injectedSolutionConstraint_ == null ? InjectedSolutionConstraint.getDefaultInstance() : this.injectedSolutionConstraint_;
    }

    @Override
    public List<ShipmentRoute> getRefreshDetailsRoutesList() {
        return this.refreshDetailsRoutes_;
    }

    @Override
    public List<? extends ShipmentRouteOrBuilder> getRefreshDetailsRoutesOrBuilderList() {
        return this.refreshDetailsRoutes_;
    }

    @Override
    public int getRefreshDetailsRoutesCount() {
        return this.refreshDetailsRoutes_.size();
    }

    @Override
    public ShipmentRoute getRefreshDetailsRoutes(int index) {
        return this.refreshDetailsRoutes_.get(index);
    }

    @Override
    public ShipmentRouteOrBuilder getRefreshDetailsRoutesOrBuilder(int index) {
        return this.refreshDetailsRoutes_.get(index);
    }

    @Override
    public boolean getInterpretInjectedSolutionsUsingLabels() {
        return this.interpretInjectedSolutionsUsingLabels_;
    }

    @Override
    public boolean getConsiderRoadTraffic() {
        return this.considerRoadTraffic_;
    }

    @Override
    public boolean getPopulatePolylines() {
        return this.populatePolylines_;
    }

    @Override
    public boolean getPopulateTransitionPolylines() {
        return this.populateTransitionPolylines_;
    }

    @Override
    public boolean getAllowLargeDeadlineDespiteInterruptionRisk() {
        return this.allowLargeDeadlineDespiteInterruptionRisk_;
    }

    @Override
    public boolean getUseGeodesicDistances() {
        return this.useGeodesicDistances_;
    }

    @Override
    public boolean hasGeodesicMetersPerSecond() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public double getGeodesicMetersPerSecond() {
        return this.geodesicMetersPerSecond_;
    }

    @Override
    public String getLabel() {
        Object ref = this.label_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.label_ = s;
        return s;
    }

    @Override
    public ByteString getLabelBytes() {
        Object ref = this.label_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.label_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    @Deprecated
    public boolean getPopulateTravelStepPolylines() {
        return this.populateTravelStepPolylines_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.parent_);
        }
        if (this.timeout_ != null) {
            output.writeMessage(2, (MessageLite)this.getTimeout());
        }
        if (this.model_ != null) {
            output.writeMessage(3, (MessageLite)this.getModel());
        }
        if (this.solvingMode_ != SolvingMode.DEFAULT_SOLVE.getNumber()) {
            output.writeEnum(4, this.solvingMode_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt32(5, this.maxValidationErrors_);
        }
        if (this.searchMode_ != SearchMode.SEARCH_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.searchMode_);
        }
        for (i = 0; i < this.injectedFirstSolutionRoutes_.size(); ++i) {
            output.writeMessage(7, (MessageLite)this.injectedFirstSolutionRoutes_.get(i));
        }
        if (this.injectedSolutionConstraint_ != null) {
            output.writeMessage(8, (MessageLite)this.getInjectedSolutionConstraint());
        }
        for (i = 0; i < this.refreshDetailsRoutes_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.refreshDetailsRoutes_.get(i));
        }
        if (this.interpretInjectedSolutionsUsingLabels_) {
            output.writeBool(10, this.interpretInjectedSolutionsUsingLabels_);
        }
        if (this.considerRoadTraffic_) {
            output.writeBool(11, this.considerRoadTraffic_);
        }
        if (this.populatePolylines_) {
            output.writeBool(12, this.populatePolylines_);
        }
        if (this.populateTransitionPolylines_) {
            output.writeBool(13, this.populateTransitionPolylines_);
        }
        if (this.allowLargeDeadlineDespiteInterruptionRisk_) {
            output.writeBool(14, this.allowLargeDeadlineDespiteInterruptionRisk_);
        }
        if (this.useGeodesicDistances_) {
            output.writeBool(15, this.useGeodesicDistances_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeDouble(16, this.geodesicMetersPerSecond_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)17, (Object)this.label_);
        }
        if (this.populateTravelStepPolylines_) {
            output.writeBool(20, this.populateTravelStepPolylines_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.parent_);
        }
        if (this.timeout_ != null) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getTimeout());
        }
        if (this.model_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getModel());
        }
        if (this.solvingMode_ != SolvingMode.DEFAULT_SOLVE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.solvingMode_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt32Size((int)5, (int)this.maxValidationErrors_);
        }
        if (this.searchMode_ != SearchMode.SEARCH_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.searchMode_);
        }
        for (i = 0; i < this.injectedFirstSolutionRoutes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((MessageLite)this.injectedFirstSolutionRoutes_.get(i)));
        }
        if (this.injectedSolutionConstraint_ != null) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getInjectedSolutionConstraint());
        }
        for (i = 0; i < this.refreshDetailsRoutes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.refreshDetailsRoutes_.get(i)));
        }
        if (this.interpretInjectedSolutionsUsingLabels_) {
            size += CodedOutputStream.computeBoolSize((int)10, (boolean)this.interpretInjectedSolutionsUsingLabels_);
        }
        if (this.considerRoadTraffic_) {
            size += CodedOutputStream.computeBoolSize((int)11, (boolean)this.considerRoadTraffic_);
        }
        if (this.populatePolylines_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.populatePolylines_);
        }
        if (this.populateTransitionPolylines_) {
            size += CodedOutputStream.computeBoolSize((int)13, (boolean)this.populateTransitionPolylines_);
        }
        if (this.allowLargeDeadlineDespiteInterruptionRisk_) {
            size += CodedOutputStream.computeBoolSize((int)14, (boolean)this.allowLargeDeadlineDespiteInterruptionRisk_);
        }
        if (this.useGeodesicDistances_) {
            size += CodedOutputStream.computeBoolSize((int)15, (boolean)this.useGeodesicDistances_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeDoubleSize((int)16, (double)this.geodesicMetersPerSecond_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.label_)) {
            size += GeneratedMessageV3.computeStringSize((int)17, (Object)this.label_);
        }
        if (this.populateTravelStepPolylines_) {
            size += CodedOutputStream.computeBoolSize((int)20, (boolean)this.populateTravelStepPolylines_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptimizeToursRequest)) {
            return super.equals(obj);
        }
        OptimizeToursRequest other = (OptimizeToursRequest)obj;
        if (!this.getParent().equals(other.getParent())) {
            return false;
        }
        if (this.hasTimeout() != other.hasTimeout()) {
            return false;
        }
        if (this.hasTimeout() && !this.getTimeout().equals((Object)other.getTimeout())) {
            return false;
        }
        if (this.hasModel() != other.hasModel()) {
            return false;
        }
        if (this.hasModel() && !this.getModel().equals(other.getModel())) {
            return false;
        }
        if (this.solvingMode_ != other.solvingMode_) {
            return false;
        }
        if (this.hasMaxValidationErrors() != other.hasMaxValidationErrors()) {
            return false;
        }
        if (this.hasMaxValidationErrors() && this.getMaxValidationErrors() != other.getMaxValidationErrors()) {
            return false;
        }
        if (this.searchMode_ != other.searchMode_) {
            return false;
        }
        if (!this.getInjectedFirstSolutionRoutesList().equals(other.getInjectedFirstSolutionRoutesList())) {
            return false;
        }
        if (this.hasInjectedSolutionConstraint() != other.hasInjectedSolutionConstraint()) {
            return false;
        }
        if (this.hasInjectedSolutionConstraint() && !this.getInjectedSolutionConstraint().equals(other.getInjectedSolutionConstraint())) {
            return false;
        }
        if (!this.getRefreshDetailsRoutesList().equals(other.getRefreshDetailsRoutesList())) {
            return false;
        }
        if (this.getInterpretInjectedSolutionsUsingLabels() != other.getInterpretInjectedSolutionsUsingLabels()) {
            return false;
        }
        if (this.getConsiderRoadTraffic() != other.getConsiderRoadTraffic()) {
            return false;
        }
        if (this.getPopulatePolylines() != other.getPopulatePolylines()) {
            return false;
        }
        if (this.getPopulateTransitionPolylines() != other.getPopulateTransitionPolylines()) {
            return false;
        }
        if (this.getAllowLargeDeadlineDespiteInterruptionRisk() != other.getAllowLargeDeadlineDespiteInterruptionRisk()) {
            return false;
        }
        if (this.getUseGeodesicDistances() != other.getUseGeodesicDistances()) {
            return false;
        }
        if (this.hasGeodesicMetersPerSecond() != other.hasGeodesicMetersPerSecond()) {
            return false;
        }
        if (this.hasGeodesicMetersPerSecond() && Double.doubleToLongBits(this.getGeodesicMetersPerSecond()) != Double.doubleToLongBits(other.getGeodesicMetersPerSecond())) {
            return false;
        }
        if (!this.getLabel().equals(other.getLabel())) {
            return false;
        }
        if (this.getPopulateTravelStepPolylines() != other.getPopulateTravelStepPolylines()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + OptimizeToursRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getParent().hashCode();
        if (this.hasTimeout()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getTimeout().hashCode();
        }
        if (this.hasModel()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getModel().hashCode();
        }
        hash = 37 * hash + 4;
        hash = 53 * hash + this.solvingMode_;
        if (this.hasMaxValidationErrors()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getMaxValidationErrors();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.searchMode_;
        if (this.getInjectedFirstSolutionRoutesCount() > 0) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getInjectedFirstSolutionRoutesList().hashCode();
        }
        if (this.hasInjectedSolutionConstraint()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getInjectedSolutionConstraint().hashCode();
        }
        if (this.getRefreshDetailsRoutesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getRefreshDetailsRoutesList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getInterpretInjectedSolutionsUsingLabels());
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getConsiderRoadTraffic());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPopulatePolylines());
        hash = 37 * hash + 13;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPopulateTransitionPolylines());
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getAllowLargeDeadlineDespiteInterruptionRisk());
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getUseGeodesicDistances());
        if (this.hasGeodesicMetersPerSecond()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getGeodesicMetersPerSecond()));
        }
        hash = 37 * hash + 17;
        hash = 53 * hash + this.getLabel().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPopulateTravelStepPolylines());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static OptimizeToursRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data);
    }

    public static OptimizeToursRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OptimizeToursRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data);
    }

    public static OptimizeToursRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OptimizeToursRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data);
    }

    public static OptimizeToursRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (OptimizeToursRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static OptimizeToursRequest parseFrom(InputStream input) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static OptimizeToursRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OptimizeToursRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static OptimizeToursRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static OptimizeToursRequest parseFrom(CodedInputStream input) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static OptimizeToursRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (OptimizeToursRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return OptimizeToursRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(OptimizeToursRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static OptimizeToursRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<OptimizeToursRequest> parser() {
        return PARSER;
    }

    public Parser<OptimizeToursRequest> getParserForType() {
        return PARSER;
    }

    public OptimizeToursRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements OptimizeToursRequestOrBuilder {
        private int bitField0_;
        private Object parent_ = "";
        private Duration timeout_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> timeoutBuilder_;
        private ShipmentModel model_;
        private SingleFieldBuilderV3<ShipmentModel, ShipmentModel.Builder, ShipmentModelOrBuilder> modelBuilder_;
        private int solvingMode_ = 0;
        private int maxValidationErrors_;
        private int searchMode_ = 0;
        private List<ShipmentRoute> injectedFirstSolutionRoutes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ShipmentRoute, ShipmentRoute.Builder, ShipmentRouteOrBuilder> injectedFirstSolutionRoutesBuilder_;
        private InjectedSolutionConstraint injectedSolutionConstraint_;
        private SingleFieldBuilderV3<InjectedSolutionConstraint, InjectedSolutionConstraint.Builder, InjectedSolutionConstraintOrBuilder> injectedSolutionConstraintBuilder_;
        private List<ShipmentRoute> refreshDetailsRoutes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<ShipmentRoute, ShipmentRoute.Builder, ShipmentRouteOrBuilder> refreshDetailsRoutesBuilder_;
        private boolean interpretInjectedSolutionsUsingLabels_;
        private boolean considerRoadTraffic_;
        private boolean populatePolylines_;
        private boolean populateTransitionPolylines_;
        private boolean allowLargeDeadlineDespiteInterruptionRisk_;
        private boolean useGeodesicDistances_;
        private double geodesicMetersPerSecond_;
        private Object label_ = "";
        private boolean populateTravelStepPolylines_;

        public static final Descriptors.Descriptor getDescriptor() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_OptimizeToursRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(OptimizeToursRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.parent_ = "";
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            this.model_ = null;
            if (this.modelBuilder_ != null) {
                this.modelBuilder_.dispose();
                this.modelBuilder_ = null;
            }
            this.solvingMode_ = 0;
            this.maxValidationErrors_ = 0;
            this.searchMode_ = 0;
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.injectedFirstSolutionRoutes_ = Collections.emptyList();
            } else {
                this.injectedFirstSolutionRoutes_ = null;
                this.injectedFirstSolutionRoutesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFBF;
            this.injectedSolutionConstraint_ = null;
            if (this.injectedSolutionConstraintBuilder_ != null) {
                this.injectedSolutionConstraintBuilder_.dispose();
                this.injectedSolutionConstraintBuilder_ = null;
            }
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.refreshDetailsRoutes_ = Collections.emptyList();
            } else {
                this.refreshDetailsRoutes_ = null;
                this.refreshDetailsRoutesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFEFF;
            this.interpretInjectedSolutionsUsingLabels_ = false;
            this.considerRoadTraffic_ = false;
            this.populatePolylines_ = false;
            this.populateTransitionPolylines_ = false;
            this.allowLargeDeadlineDespiteInterruptionRisk_ = false;
            this.useGeodesicDistances_ = false;
            this.geodesicMetersPerSecond_ = 0.0;
            this.label_ = "";
            this.populateTravelStepPolylines_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FleetRoutingProto.internal_static_google_cloud_optimization_v1_OptimizeToursRequest_descriptor;
        }

        public OptimizeToursRequest getDefaultInstanceForType() {
            return OptimizeToursRequest.getDefaultInstance();
        }

        public OptimizeToursRequest build() {
            OptimizeToursRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public OptimizeToursRequest buildPartial() {
            OptimizeToursRequest result = new OptimizeToursRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(OptimizeToursRequest result) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0) {
                    this.injectedFirstSolutionRoutes_ = Collections.unmodifiableList(this.injectedFirstSolutionRoutes_);
                    this.bitField0_ &= 0xFFFFFFBF;
                }
                result.injectedFirstSolutionRoutes_ = this.injectedFirstSolutionRoutes_;
            } else {
                result.injectedFirstSolutionRoutes_ = this.injectedFirstSolutionRoutesBuilder_.build();
            }
            if (this.refreshDetailsRoutesBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0) {
                    this.refreshDetailsRoutes_ = Collections.unmodifiableList(this.refreshDetailsRoutes_);
                    this.bitField0_ &= 0xFFFFFEFF;
                }
                result.refreshDetailsRoutes_ = this.refreshDetailsRoutes_;
            } else {
                result.refreshDetailsRoutes_ = this.refreshDetailsRoutesBuilder_.build();
            }
        }

        private void buildPartial0(OptimizeToursRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.parent_ = this.parent_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.timeout_ = this.timeoutBuilder_ == null ? this.timeout_ : (Duration)this.timeoutBuilder_.build();
            }
            if ((from_bitField0_ & 4) != 0) {
                result.model_ = this.modelBuilder_ == null ? this.model_ : (ShipmentModel)this.modelBuilder_.build();
            }
            if ((from_bitField0_ & 8) != 0) {
                result.solvingMode_ = this.solvingMode_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.maxValidationErrors_ = this.maxValidationErrors_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.searchMode_ = this.searchMode_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.injectedSolutionConstraint_ = this.injectedSolutionConstraintBuilder_ == null ? this.injectedSolutionConstraint_ : (InjectedSolutionConstraint)this.injectedSolutionConstraintBuilder_.build();
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.interpretInjectedSolutionsUsingLabels_ = this.interpretInjectedSolutionsUsingLabels_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.considerRoadTraffic_ = this.considerRoadTraffic_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.populatePolylines_ = this.populatePolylines_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.populateTransitionPolylines_ = this.populateTransitionPolylines_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.allowLargeDeadlineDespiteInterruptionRisk_ = this.allowLargeDeadlineDespiteInterruptionRisk_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.useGeodesicDistances_ = this.useGeodesicDistances_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.geodesicMetersPerSecond_ = this.geodesicMetersPerSecond_;
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.label_ = this.label_;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.populateTravelStepPolylines_ = this.populateTravelStepPolylines_;
            }
            OptimizeToursRequest optimizeToursRequest = result;
            optimizeToursRequest.bitField0_ = optimizeToursRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof OptimizeToursRequest) {
                return this.mergeFrom((OptimizeToursRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(OptimizeToursRequest other) {
            if (other == OptimizeToursRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getParent().isEmpty()) {
                this.parent_ = other.parent_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.hasTimeout()) {
                this.mergeTimeout(other.getTimeout());
            }
            if (other.hasModel()) {
                this.mergeModel(other.getModel());
            }
            if (other.solvingMode_ != 0) {
                this.setSolvingModeValue(other.getSolvingModeValue());
            }
            if (other.hasMaxValidationErrors()) {
                this.setMaxValidationErrors(other.getMaxValidationErrors());
            }
            if (other.searchMode_ != 0) {
                this.setSearchModeValue(other.getSearchModeValue());
            }
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                if (!other.injectedFirstSolutionRoutes_.isEmpty()) {
                    if (this.injectedFirstSolutionRoutes_.isEmpty()) {
                        this.injectedFirstSolutionRoutes_ = other.injectedFirstSolutionRoutes_;
                        this.bitField0_ &= 0xFFFFFFBF;
                    } else {
                        this.ensureInjectedFirstSolutionRoutesIsMutable();
                        this.injectedFirstSolutionRoutes_.addAll(other.injectedFirstSolutionRoutes_);
                    }
                    this.onChanged();
                }
            } else if (!other.injectedFirstSolutionRoutes_.isEmpty()) {
                if (this.injectedFirstSolutionRoutesBuilder_.isEmpty()) {
                    this.injectedFirstSolutionRoutesBuilder_.dispose();
                    this.injectedFirstSolutionRoutesBuilder_ = null;
                    this.injectedFirstSolutionRoutes_ = other.injectedFirstSolutionRoutes_;
                    this.bitField0_ &= 0xFFFFFFBF;
                    this.injectedFirstSolutionRoutesBuilder_ = alwaysUseFieldBuilders ? this.getInjectedFirstSolutionRoutesFieldBuilder() : null;
                } else {
                    this.injectedFirstSolutionRoutesBuilder_.addAllMessages((Iterable)other.injectedFirstSolutionRoutes_);
                }
            }
            if (other.hasInjectedSolutionConstraint()) {
                this.mergeInjectedSolutionConstraint(other.getInjectedSolutionConstraint());
            }
            if (this.refreshDetailsRoutesBuilder_ == null) {
                if (!other.refreshDetailsRoutes_.isEmpty()) {
                    if (this.refreshDetailsRoutes_.isEmpty()) {
                        this.refreshDetailsRoutes_ = other.refreshDetailsRoutes_;
                        this.bitField0_ &= 0xFFFFFEFF;
                    } else {
                        this.ensureRefreshDetailsRoutesIsMutable();
                        this.refreshDetailsRoutes_.addAll(other.refreshDetailsRoutes_);
                    }
                    this.onChanged();
                }
            } else if (!other.refreshDetailsRoutes_.isEmpty()) {
                if (this.refreshDetailsRoutesBuilder_.isEmpty()) {
                    this.refreshDetailsRoutesBuilder_.dispose();
                    this.refreshDetailsRoutesBuilder_ = null;
                    this.refreshDetailsRoutes_ = other.refreshDetailsRoutes_;
                    this.bitField0_ &= 0xFFFFFEFF;
                    this.refreshDetailsRoutesBuilder_ = alwaysUseFieldBuilders ? this.getRefreshDetailsRoutesFieldBuilder() : null;
                } else {
                    this.refreshDetailsRoutesBuilder_.addAllMessages((Iterable)other.refreshDetailsRoutes_);
                }
            }
            if (other.getInterpretInjectedSolutionsUsingLabels()) {
                this.setInterpretInjectedSolutionsUsingLabels(other.getInterpretInjectedSolutionsUsingLabels());
            }
            if (other.getConsiderRoadTraffic()) {
                this.setConsiderRoadTraffic(other.getConsiderRoadTraffic());
            }
            if (other.getPopulatePolylines()) {
                this.setPopulatePolylines(other.getPopulatePolylines());
            }
            if (other.getPopulateTransitionPolylines()) {
                this.setPopulateTransitionPolylines(other.getPopulateTransitionPolylines());
            }
            if (other.getAllowLargeDeadlineDespiteInterruptionRisk()) {
                this.setAllowLargeDeadlineDespiteInterruptionRisk(other.getAllowLargeDeadlineDespiteInterruptionRisk());
            }
            if (other.getUseGeodesicDistances()) {
                this.setUseGeodesicDistances(other.getUseGeodesicDistances());
            }
            if (other.hasGeodesicMetersPerSecond()) {
                this.setGeodesicMetersPerSecond(other.getGeodesicMetersPerSecond());
            }
            if (!other.getLabel().isEmpty()) {
                this.label_ = other.label_;
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            if (other.getPopulateTravelStepPolylines()) {
                this.setPopulateTravelStepPolylines(other.getPopulateTravelStepPolylines());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block26: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block26;
                        }
                        case 10: {
                            this.parent_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block26;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block26;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getModelFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block26;
                        }
                        case 32: {
                            this.solvingMode_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block26;
                        }
                        case 40: {
                            this.maxValidationErrors_ = input.readInt32();
                            this.bitField0_ |= 0x10;
                            continue block26;
                        }
                        case 48: {
                            this.searchMode_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block26;
                        }
                        case 58: {
                            ShipmentRoute m = (ShipmentRoute)input.readMessage(ShipmentRoute.parser(), extensionRegistry);
                            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                                this.ensureInjectedFirstSolutionRoutesIsMutable();
                                this.injectedFirstSolutionRoutes_.add(m);
                                continue block26;
                            }
                            this.injectedFirstSolutionRoutesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getInjectedSolutionConstraintFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block26;
                        }
                        case 74: {
                            ShipmentRoute m = (ShipmentRoute)input.readMessage(ShipmentRoute.parser(), extensionRegistry);
                            if (this.refreshDetailsRoutesBuilder_ == null) {
                                this.ensureRefreshDetailsRoutesIsMutable();
                                this.refreshDetailsRoutes_.add(m);
                                continue block26;
                            }
                            this.refreshDetailsRoutesBuilder_.addMessage((AbstractMessage)m);
                            continue block26;
                        }
                        case 80: {
                            this.interpretInjectedSolutionsUsingLabels_ = input.readBool();
                            this.bitField0_ |= 0x200;
                            continue block26;
                        }
                        case 88: {
                            this.considerRoadTraffic_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block26;
                        }
                        case 96: {
                            this.populatePolylines_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block26;
                        }
                        case 104: {
                            this.populateTransitionPolylines_ = input.readBool();
                            this.bitField0_ |= 0x1000;
                            continue block26;
                        }
                        case 112: {
                            this.allowLargeDeadlineDespiteInterruptionRisk_ = input.readBool();
                            this.bitField0_ |= 0x2000;
                            continue block26;
                        }
                        case 120: {
                            this.useGeodesicDistances_ = input.readBool();
                            this.bitField0_ |= 0x4000;
                            continue block26;
                        }
                        case 129: {
                            this.geodesicMetersPerSecond_ = input.readDouble();
                            this.bitField0_ |= 0x8000;
                            continue block26;
                        }
                        case 138: {
                            this.label_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10000;
                            continue block26;
                        }
                        case 160: {
                            this.populateTravelStepPolylines_ = input.readBool();
                            this.bitField0_ |= 0x20000;
                            continue block26;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getParent() {
            Object ref = this.parent_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.parent_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getParentBytes() {
            Object ref = this.parent_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.parent_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setParent(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parent_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearParent() {
            this.parent_ = OptimizeToursRequest.getDefaultInstance().getParent();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setParentBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OptimizeToursRequest.checkByteStringIsUtf8((ByteString)value);
            this.parent_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasTimeout() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public Duration getTimeout() {
            if (this.timeoutBuilder_ == null) {
                return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
            }
            return (Duration)this.timeoutBuilder_.getMessage();
        }

        public Builder setTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.timeout_ = value;
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setTimeout(Duration.Builder builderForValue) {
            if (this.timeoutBuilder_ == null) {
                this.timeout_ = builderForValue.build();
            } else {
                this.timeoutBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeTimeout(Duration value) {
            if (this.timeoutBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.timeout_ != null && this.timeout_ != Duration.getDefaultInstance()) {
                    this.getTimeoutBuilder().mergeFrom(value);
                } else {
                    this.timeout_ = value;
                }
            } else {
                this.timeoutBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearTimeout() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.timeout_ = null;
            if (this.timeoutBuilder_ != null) {
                this.timeoutBuilder_.dispose();
                this.timeoutBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getTimeoutBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (Duration.Builder)this.getTimeoutFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getTimeoutOrBuilder() {
            if (this.timeoutBuilder_ != null) {
                return (DurationOrBuilder)this.timeoutBuilder_.getMessageOrBuilder();
            }
            return this.timeout_ == null ? Duration.getDefaultInstance() : this.timeout_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getTimeoutFieldBuilder() {
            if (this.timeoutBuilder_ == null) {
                this.timeoutBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTimeout(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.timeout_ = null;
            }
            return this.timeoutBuilder_;
        }

        @Override
        public boolean hasModel() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public ShipmentModel getModel() {
            if (this.modelBuilder_ == null) {
                return this.model_ == null ? ShipmentModel.getDefaultInstance() : this.model_;
            }
            return (ShipmentModel)this.modelBuilder_.getMessage();
        }

        public Builder setModel(ShipmentModel value) {
            if (this.modelBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.model_ = value;
            } else {
                this.modelBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setModel(ShipmentModel.Builder builderForValue) {
            if (this.modelBuilder_ == null) {
                this.model_ = builderForValue.build();
            } else {
                this.modelBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeModel(ShipmentModel value) {
            if (this.modelBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.model_ != null && this.model_ != ShipmentModel.getDefaultInstance()) {
                    this.getModelBuilder().mergeFrom(value);
                } else {
                    this.model_ = value;
                }
            } else {
                this.modelBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearModel() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.model_ = null;
            if (this.modelBuilder_ != null) {
                this.modelBuilder_.dispose();
                this.modelBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ShipmentModel.Builder getModelBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (ShipmentModel.Builder)this.getModelFieldBuilder().getBuilder();
        }

        @Override
        public ShipmentModelOrBuilder getModelOrBuilder() {
            if (this.modelBuilder_ != null) {
                return (ShipmentModelOrBuilder)this.modelBuilder_.getMessageOrBuilder();
            }
            return this.model_ == null ? ShipmentModel.getDefaultInstance() : this.model_;
        }

        private SingleFieldBuilderV3<ShipmentModel, ShipmentModel.Builder, ShipmentModelOrBuilder> getModelFieldBuilder() {
            if (this.modelBuilder_ == null) {
                this.modelBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getModel(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.model_ = null;
            }
            return this.modelBuilder_;
        }

        @Override
        public int getSolvingModeValue() {
            return this.solvingMode_;
        }

        public Builder setSolvingModeValue(int value) {
            this.solvingMode_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public SolvingMode getSolvingMode() {
            SolvingMode result = SolvingMode.forNumber(this.solvingMode_);
            return result == null ? SolvingMode.UNRECOGNIZED : result;
        }

        public Builder setSolvingMode(SolvingMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.solvingMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSolvingMode() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.solvingMode_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaxValidationErrors() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public int getMaxValidationErrors() {
            return this.maxValidationErrors_;
        }

        public Builder setMaxValidationErrors(int value) {
            this.maxValidationErrors_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearMaxValidationErrors() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.maxValidationErrors_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getSearchModeValue() {
            return this.searchMode_;
        }

        public Builder setSearchModeValue(int value) {
            this.searchMode_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public SearchMode getSearchMode() {
            SearchMode result = SearchMode.forNumber(this.searchMode_);
            return result == null ? SearchMode.UNRECOGNIZED : result;
        }

        public Builder setSearchMode(SearchMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.searchMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearSearchMode() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.searchMode_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureInjectedFirstSolutionRoutesIsMutable() {
            if ((this.bitField0_ & 0x40) == 0) {
                this.injectedFirstSolutionRoutes_ = new ArrayList<ShipmentRoute>(this.injectedFirstSolutionRoutes_);
                this.bitField0_ |= 0x40;
            }
        }

        @Override
        public List<ShipmentRoute> getInjectedFirstSolutionRoutesList() {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                return Collections.unmodifiableList(this.injectedFirstSolutionRoutes_);
            }
            return this.injectedFirstSolutionRoutesBuilder_.getMessageList();
        }

        @Override
        public int getInjectedFirstSolutionRoutesCount() {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                return this.injectedFirstSolutionRoutes_.size();
            }
            return this.injectedFirstSolutionRoutesBuilder_.getCount();
        }

        @Override
        public ShipmentRoute getInjectedFirstSolutionRoutes(int index) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                return this.injectedFirstSolutionRoutes_.get(index);
            }
            return (ShipmentRoute)this.injectedFirstSolutionRoutesBuilder_.getMessage(index);
        }

        public Builder setInjectedFirstSolutionRoutes(int index, ShipmentRoute value) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.set(index, value);
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setInjectedFirstSolutionRoutes(int index, ShipmentRoute.Builder builderForValue) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInjectedFirstSolutionRoutes(ShipmentRoute value) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.add(value);
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addInjectedFirstSolutionRoutes(int index, ShipmentRoute value) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.add(index, value);
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addInjectedFirstSolutionRoutes(ShipmentRoute.Builder builderForValue) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addInjectedFirstSolutionRoutes(int index, ShipmentRoute.Builder builderForValue) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllInjectedFirstSolutionRoutes(Iterable<? extends ShipmentRoute> values) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.injectedFirstSolutionRoutes_);
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearInjectedFirstSolutionRoutes() {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.injectedFirstSolutionRoutes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFBF;
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.clear();
            }
            return this;
        }

        public Builder removeInjectedFirstSolutionRoutes(int index) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.ensureInjectedFirstSolutionRoutesIsMutable();
                this.injectedFirstSolutionRoutes_.remove(index);
                this.onChanged();
            } else {
                this.injectedFirstSolutionRoutesBuilder_.remove(index);
            }
            return this;
        }

        public ShipmentRoute.Builder getInjectedFirstSolutionRoutesBuilder(int index) {
            return (ShipmentRoute.Builder)this.getInjectedFirstSolutionRoutesFieldBuilder().getBuilder(index);
        }

        @Override
        public ShipmentRouteOrBuilder getInjectedFirstSolutionRoutesOrBuilder(int index) {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                return this.injectedFirstSolutionRoutes_.get(index);
            }
            return (ShipmentRouteOrBuilder)this.injectedFirstSolutionRoutesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ShipmentRouteOrBuilder> getInjectedFirstSolutionRoutesOrBuilderList() {
            if (this.injectedFirstSolutionRoutesBuilder_ != null) {
                return this.injectedFirstSolutionRoutesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.injectedFirstSolutionRoutes_);
        }

        public ShipmentRoute.Builder addInjectedFirstSolutionRoutesBuilder() {
            return (ShipmentRoute.Builder)this.getInjectedFirstSolutionRoutesFieldBuilder().addBuilder((AbstractMessage)ShipmentRoute.getDefaultInstance());
        }

        public ShipmentRoute.Builder addInjectedFirstSolutionRoutesBuilder(int index) {
            return (ShipmentRoute.Builder)this.getInjectedFirstSolutionRoutesFieldBuilder().addBuilder(index, (AbstractMessage)ShipmentRoute.getDefaultInstance());
        }

        public List<ShipmentRoute.Builder> getInjectedFirstSolutionRoutesBuilderList() {
            return this.getInjectedFirstSolutionRoutesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ShipmentRoute, ShipmentRoute.Builder, ShipmentRouteOrBuilder> getInjectedFirstSolutionRoutesFieldBuilder() {
            if (this.injectedFirstSolutionRoutesBuilder_ == null) {
                this.injectedFirstSolutionRoutesBuilder_ = new RepeatedFieldBuilderV3(this.injectedFirstSolutionRoutes_, (this.bitField0_ & 0x40) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.injectedFirstSolutionRoutes_ = null;
            }
            return this.injectedFirstSolutionRoutesBuilder_;
        }

        @Override
        public boolean hasInjectedSolutionConstraint() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public InjectedSolutionConstraint getInjectedSolutionConstraint() {
            if (this.injectedSolutionConstraintBuilder_ == null) {
                return this.injectedSolutionConstraint_ == null ? InjectedSolutionConstraint.getDefaultInstance() : this.injectedSolutionConstraint_;
            }
            return (InjectedSolutionConstraint)this.injectedSolutionConstraintBuilder_.getMessage();
        }

        public Builder setInjectedSolutionConstraint(InjectedSolutionConstraint value) {
            if (this.injectedSolutionConstraintBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.injectedSolutionConstraint_ = value;
            } else {
                this.injectedSolutionConstraintBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setInjectedSolutionConstraint(InjectedSolutionConstraint.Builder builderForValue) {
            if (this.injectedSolutionConstraintBuilder_ == null) {
                this.injectedSolutionConstraint_ = builderForValue.build();
            } else {
                this.injectedSolutionConstraintBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeInjectedSolutionConstraint(InjectedSolutionConstraint value) {
            if (this.injectedSolutionConstraintBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.injectedSolutionConstraint_ != null && this.injectedSolutionConstraint_ != InjectedSolutionConstraint.getDefaultInstance()) {
                    this.getInjectedSolutionConstraintBuilder().mergeFrom(value);
                } else {
                    this.injectedSolutionConstraint_ = value;
                }
            } else {
                this.injectedSolutionConstraintBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearInjectedSolutionConstraint() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.injectedSolutionConstraint_ = null;
            if (this.injectedSolutionConstraintBuilder_ != null) {
                this.injectedSolutionConstraintBuilder_.dispose();
                this.injectedSolutionConstraintBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public InjectedSolutionConstraint.Builder getInjectedSolutionConstraintBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (InjectedSolutionConstraint.Builder)this.getInjectedSolutionConstraintFieldBuilder().getBuilder();
        }

        @Override
        public InjectedSolutionConstraintOrBuilder getInjectedSolutionConstraintOrBuilder() {
            if (this.injectedSolutionConstraintBuilder_ != null) {
                return (InjectedSolutionConstraintOrBuilder)this.injectedSolutionConstraintBuilder_.getMessageOrBuilder();
            }
            return this.injectedSolutionConstraint_ == null ? InjectedSolutionConstraint.getDefaultInstance() : this.injectedSolutionConstraint_;
        }

        private SingleFieldBuilderV3<InjectedSolutionConstraint, InjectedSolutionConstraint.Builder, InjectedSolutionConstraintOrBuilder> getInjectedSolutionConstraintFieldBuilder() {
            if (this.injectedSolutionConstraintBuilder_ == null) {
                this.injectedSolutionConstraintBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getInjectedSolutionConstraint(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.injectedSolutionConstraint_ = null;
            }
            return this.injectedSolutionConstraintBuilder_;
        }

        private void ensureRefreshDetailsRoutesIsMutable() {
            if ((this.bitField0_ & 0x100) == 0) {
                this.refreshDetailsRoutes_ = new ArrayList<ShipmentRoute>(this.refreshDetailsRoutes_);
                this.bitField0_ |= 0x100;
            }
        }

        @Override
        public List<ShipmentRoute> getRefreshDetailsRoutesList() {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                return Collections.unmodifiableList(this.refreshDetailsRoutes_);
            }
            return this.refreshDetailsRoutesBuilder_.getMessageList();
        }

        @Override
        public int getRefreshDetailsRoutesCount() {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                return this.refreshDetailsRoutes_.size();
            }
            return this.refreshDetailsRoutesBuilder_.getCount();
        }

        @Override
        public ShipmentRoute getRefreshDetailsRoutes(int index) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                return this.refreshDetailsRoutes_.get(index);
            }
            return (ShipmentRoute)this.refreshDetailsRoutesBuilder_.getMessage(index);
        }

        public Builder setRefreshDetailsRoutes(int index, ShipmentRoute value) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.set(index, value);
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setRefreshDetailsRoutes(int index, ShipmentRoute.Builder builderForValue) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRefreshDetailsRoutes(ShipmentRoute value) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.add(value);
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addRefreshDetailsRoutes(int index, ShipmentRoute value) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.add(index, value);
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addRefreshDetailsRoutes(ShipmentRoute.Builder builderForValue) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addRefreshDetailsRoutes(int index, ShipmentRoute.Builder builderForValue) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllRefreshDetailsRoutes(Iterable<? extends ShipmentRoute> values) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.ensureRefreshDetailsRoutesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.refreshDetailsRoutes_);
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearRefreshDetailsRoutes() {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.refreshDetailsRoutes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFEFF;
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.clear();
            }
            return this;
        }

        public Builder removeRefreshDetailsRoutes(int index) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.ensureRefreshDetailsRoutesIsMutable();
                this.refreshDetailsRoutes_.remove(index);
                this.onChanged();
            } else {
                this.refreshDetailsRoutesBuilder_.remove(index);
            }
            return this;
        }

        public ShipmentRoute.Builder getRefreshDetailsRoutesBuilder(int index) {
            return (ShipmentRoute.Builder)this.getRefreshDetailsRoutesFieldBuilder().getBuilder(index);
        }

        @Override
        public ShipmentRouteOrBuilder getRefreshDetailsRoutesOrBuilder(int index) {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                return this.refreshDetailsRoutes_.get(index);
            }
            return (ShipmentRouteOrBuilder)this.refreshDetailsRoutesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ShipmentRouteOrBuilder> getRefreshDetailsRoutesOrBuilderList() {
            if (this.refreshDetailsRoutesBuilder_ != null) {
                return this.refreshDetailsRoutesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.refreshDetailsRoutes_);
        }

        public ShipmentRoute.Builder addRefreshDetailsRoutesBuilder() {
            return (ShipmentRoute.Builder)this.getRefreshDetailsRoutesFieldBuilder().addBuilder((AbstractMessage)ShipmentRoute.getDefaultInstance());
        }

        public ShipmentRoute.Builder addRefreshDetailsRoutesBuilder(int index) {
            return (ShipmentRoute.Builder)this.getRefreshDetailsRoutesFieldBuilder().addBuilder(index, (AbstractMessage)ShipmentRoute.getDefaultInstance());
        }

        public List<ShipmentRoute.Builder> getRefreshDetailsRoutesBuilderList() {
            return this.getRefreshDetailsRoutesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<ShipmentRoute, ShipmentRoute.Builder, ShipmentRouteOrBuilder> getRefreshDetailsRoutesFieldBuilder() {
            if (this.refreshDetailsRoutesBuilder_ == null) {
                this.refreshDetailsRoutesBuilder_ = new RepeatedFieldBuilderV3(this.refreshDetailsRoutes_, (this.bitField0_ & 0x100) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.refreshDetailsRoutes_ = null;
            }
            return this.refreshDetailsRoutesBuilder_;
        }

        @Override
        public boolean getInterpretInjectedSolutionsUsingLabels() {
            return this.interpretInjectedSolutionsUsingLabels_;
        }

        public Builder setInterpretInjectedSolutionsUsingLabels(boolean value) {
            this.interpretInjectedSolutionsUsingLabels_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearInterpretInjectedSolutionsUsingLabels() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.interpretInjectedSolutionsUsingLabels_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getConsiderRoadTraffic() {
            return this.considerRoadTraffic_;
        }

        public Builder setConsiderRoadTraffic(boolean value) {
            this.considerRoadTraffic_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearConsiderRoadTraffic() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.considerRoadTraffic_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getPopulatePolylines() {
            return this.populatePolylines_;
        }

        public Builder setPopulatePolylines(boolean value) {
            this.populatePolylines_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearPopulatePolylines() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.populatePolylines_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getPopulateTransitionPolylines() {
            return this.populateTransitionPolylines_;
        }

        public Builder setPopulateTransitionPolylines(boolean value) {
            this.populateTransitionPolylines_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearPopulateTransitionPolylines() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.populateTransitionPolylines_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getAllowLargeDeadlineDespiteInterruptionRisk() {
            return this.allowLargeDeadlineDespiteInterruptionRisk_;
        }

        public Builder setAllowLargeDeadlineDespiteInterruptionRisk(boolean value) {
            this.allowLargeDeadlineDespiteInterruptionRisk_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearAllowLargeDeadlineDespiteInterruptionRisk() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.allowLargeDeadlineDespiteInterruptionRisk_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getUseGeodesicDistances() {
            return this.useGeodesicDistances_;
        }

        public Builder setUseGeodesicDistances(boolean value) {
            this.useGeodesicDistances_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearUseGeodesicDistances() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.useGeodesicDistances_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasGeodesicMetersPerSecond() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public double getGeodesicMetersPerSecond() {
            return this.geodesicMetersPerSecond_;
        }

        public Builder setGeodesicMetersPerSecond(double value) {
            this.geodesicMetersPerSecond_ = value;
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder clearGeodesicMetersPerSecond() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.geodesicMetersPerSecond_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public String getLabel() {
            Object ref = this.label_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.label_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getLabelBytes() {
            Object ref = this.label_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.label_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setLabel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.label_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder clearLabel() {
            this.label_ = OptimizeToursRequest.getDefaultInstance().getLabel();
            this.bitField0_ &= 0xFFFEFFFF;
            this.onChanged();
            return this;
        }

        public Builder setLabelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            OptimizeToursRequest.checkByteStringIsUtf8((ByteString)value);
            this.label_ = value;
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        @Override
        @Deprecated
        public boolean getPopulateTravelStepPolylines() {
            return this.populateTravelStepPolylines_;
        }

        @Deprecated
        public Builder setPopulateTravelStepPolylines(boolean value) {
            this.populateTravelStepPolylines_ = value;
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearPopulateTravelStepPolylines() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.populateTravelStepPolylines_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SearchMode implements ProtocolMessageEnum
    {
        SEARCH_MODE_UNSPECIFIED(0),
        RETURN_FAST(1),
        CONSUME_ALL_AVAILABLE_TIME(2),
        UNRECOGNIZED(-1);

        public static final int SEARCH_MODE_UNSPECIFIED_VALUE = 0;
        public static final int RETURN_FAST_VALUE = 1;
        public static final int CONSUME_ALL_AVAILABLE_TIME_VALUE = 2;
        private static final Internal.EnumLiteMap<SearchMode> internalValueMap;
        private static final SearchMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SearchMode valueOf(int value) {
            return SearchMode.forNumber(value);
        }

        public static SearchMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return SEARCH_MODE_UNSPECIFIED;
                }
                case 1: {
                    return RETURN_FAST;
                }
                case 2: {
                    return CONSUME_ALL_AVAILABLE_TIME;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SearchMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SearchMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SearchMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)OptimizeToursRequest.getDescriptor().getEnumTypes().get(1);
        }

        public static SearchMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SearchMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SearchMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SearchMode>(){

                public SearchMode findValueByNumber(int number) {
                    return SearchMode.forNumber(number);
                }
            };
            VALUES = SearchMode.values();
        }
    }

    public static enum SolvingMode implements ProtocolMessageEnum
    {
        DEFAULT_SOLVE(0),
        VALIDATE_ONLY(1),
        DETECT_SOME_INFEASIBLE_SHIPMENTS(2),
        UNRECOGNIZED(-1);

        public static final int DEFAULT_SOLVE_VALUE = 0;
        public static final int VALIDATE_ONLY_VALUE = 1;
        public static final int DETECT_SOME_INFEASIBLE_SHIPMENTS_VALUE = 2;
        private static final Internal.EnumLiteMap<SolvingMode> internalValueMap;
        private static final SolvingMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SolvingMode valueOf(int value) {
            return SolvingMode.forNumber(value);
        }

        public static SolvingMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return DEFAULT_SOLVE;
                }
                case 1: {
                    return VALIDATE_ONLY;
                }
                case 2: {
                    return DETECT_SOME_INFEASIBLE_SHIPMENTS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SolvingMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SolvingMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SolvingMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)OptimizeToursRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static SolvingMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SolvingMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SolvingMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<SolvingMode>(){

                public SolvingMode findValueByNumber(int number) {
                    return SolvingMode.forNumber(number);
                }
            };
            VALUES = SolvingMode.values();
        }
    }
}

