/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WasmPluginVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WASM_PLUGIN_WASM_PLUGIN_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}/versions/{wasm_plugin_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String wasmPlugin;
    private final String wasmPluginVersion;

    @Deprecated
    protected WasmPluginVersionName() {
        this.project = null;
        this.location = null;
        this.wasmPlugin = null;
        this.wasmPluginVersion = null;
    }

    private WasmPluginVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.wasmPlugin = (String)Preconditions.checkNotNull((Object)builder.getWasmPlugin());
        this.wasmPluginVersion = (String)Preconditions.checkNotNull((Object)builder.getWasmPluginVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWasmPlugin() {
        return this.wasmPlugin;
    }

    public String getWasmPluginVersion() {
        return this.wasmPluginVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WasmPluginVersionName of(String project, String location, String wasmPlugin, String wasmPluginVersion) {
        return WasmPluginVersionName.newBuilder().setProject(project).setLocation(location).setWasmPlugin(wasmPlugin).setWasmPluginVersion(wasmPluginVersion).build();
    }

    public static String format(String project, String location, String wasmPlugin, String wasmPluginVersion) {
        return WasmPluginVersionName.newBuilder().setProject(project).setLocation(location).setWasmPlugin(wasmPlugin).setWasmPluginVersion(wasmPluginVersion).build().toString();
    }

    public static WasmPluginVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WASM_PLUGIN_WASM_PLUGIN_VERSION.validatedMatch(formattedString, "WasmPluginVersionName.parse: formattedString not in valid format");
        return WasmPluginVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("wasm_plugin"), (String)matchMap.get("wasm_plugin_version"));
    }

    public static List<WasmPluginVersionName> parseList(List<String> formattedStrings) {
        ArrayList<WasmPluginVersionName> list = new ArrayList<WasmPluginVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WasmPluginVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WasmPluginVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WasmPluginVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WASM_PLUGIN_WASM_PLUGIN_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WasmPluginVersionName wasmPluginVersionName = this;
            synchronized (wasmPluginVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.wasmPlugin != null) {
                        fieldMapBuilder.put((Object)"wasm_plugin", (Object)this.wasmPlugin);
                    }
                    if (this.wasmPluginVersion != null) {
                        fieldMapBuilder.put((Object)"wasm_plugin_version", (Object)this.wasmPluginVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WASM_PLUGIN_WASM_PLUGIN_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "wasm_plugin", this.wasmPlugin, "wasm_plugin_version", this.wasmPluginVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WasmPluginVersionName that = (WasmPluginVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.wasmPlugin, that.wasmPlugin) && Objects.equals(this.wasmPluginVersion, that.wasmPluginVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.wasmPlugin);
        h *= 1000003;
        return h ^= Objects.hashCode(this.wasmPluginVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String wasmPlugin;
        private String wasmPluginVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWasmPlugin() {
            return this.wasmPlugin;
        }

        public String getWasmPluginVersion() {
            return this.wasmPluginVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWasmPlugin(String wasmPlugin) {
            this.wasmPlugin = wasmPlugin;
            return this;
        }

        public Builder setWasmPluginVersion(String wasmPluginVersion) {
            this.wasmPluginVersion = wasmPluginVersion;
            return this;
        }

        private Builder(WasmPluginVersionName wasmPluginVersionName) {
            this.project = wasmPluginVersionName.project;
            this.location = wasmPluginVersionName.location;
            this.wasmPlugin = wasmPluginVersionName.wasmPlugin;
            this.wasmPluginVersion = wasmPluginVersionName.wasmPluginVersion;
        }

        public WasmPluginVersionName build() {
            return new WasmPluginVersionName(this);
        }
    }
}

