/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WasmPluginName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WASM_PLUGIN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/wasmPlugins/{wasm_plugin}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String wasmPlugin;

    @Deprecated
    protected WasmPluginName() {
        this.project = null;
        this.location = null;
        this.wasmPlugin = null;
    }

    private WasmPluginName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.wasmPlugin = (String)Preconditions.checkNotNull((Object)builder.getWasmPlugin());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWasmPlugin() {
        return this.wasmPlugin;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WasmPluginName of(String project, String location, String wasmPlugin) {
        return WasmPluginName.newBuilder().setProject(project).setLocation(location).setWasmPlugin(wasmPlugin).build();
    }

    public static String format(String project, String location, String wasmPlugin) {
        return WasmPluginName.newBuilder().setProject(project).setLocation(location).setWasmPlugin(wasmPlugin).build().toString();
    }

    public static WasmPluginName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WASM_PLUGIN.validatedMatch(formattedString, "WasmPluginName.parse: formattedString not in valid format");
        return WasmPluginName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("wasm_plugin"));
    }

    public static List<WasmPluginName> parseList(List<String> formattedStrings) {
        ArrayList<WasmPluginName> list = new ArrayList<WasmPluginName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WasmPluginName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WasmPluginName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WasmPluginName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WASM_PLUGIN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WasmPluginName wasmPluginName = this;
            synchronized (wasmPluginName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.wasmPlugin != null) {
                        fieldMapBuilder.put((Object)"wasm_plugin", (Object)this.wasmPlugin);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WASM_PLUGIN.instantiate(new String[]{"project", this.project, "location", this.location, "wasm_plugin", this.wasmPlugin});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WasmPluginName that = (WasmPluginName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.wasmPlugin, that.wasmPlugin);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.wasmPlugin);
    }

    public static class Builder {
        private String project;
        private String location;
        private String wasmPlugin;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWasmPlugin() {
            return this.wasmPlugin;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWasmPlugin(String wasmPlugin) {
            this.wasmPlugin = wasmPlugin;
            return this;
        }

        private Builder(WasmPluginName wasmPluginName) {
            this.project = wasmPluginName.project;
            this.location = wasmPluginName.location;
            this.wasmPlugin = wasmPluginName.wasmPlugin;
        }

        public WasmPluginName build() {
            return new WasmPluginName(this);
        }
    }
}

