/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TcpRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TCP_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tcpRoutes/{tcp_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tcpRoute;

    @Deprecated
    protected TcpRouteName() {
        this.project = null;
        this.location = null;
        this.tcpRoute = null;
    }

    private TcpRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tcpRoute = (String)Preconditions.checkNotNull((Object)builder.getTcpRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTcpRoute() {
        return this.tcpRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TcpRouteName of(String project, String location, String tcpRoute) {
        return TcpRouteName.newBuilder().setProject(project).setLocation(location).setTcpRoute(tcpRoute).build();
    }

    public static String format(String project, String location, String tcpRoute) {
        return TcpRouteName.newBuilder().setProject(project).setLocation(location).setTcpRoute(tcpRoute).build().toString();
    }

    public static TcpRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TCP_ROUTE.validatedMatch(formattedString, "TcpRouteName.parse: formattedString not in valid format");
        return TcpRouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tcp_route"));
    }

    public static List<TcpRouteName> parseList(List<String> formattedStrings) {
        ArrayList<TcpRouteName> list = new ArrayList<TcpRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TcpRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TcpRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TcpRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TCP_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TcpRouteName tcpRouteName = this;
            synchronized (tcpRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tcpRoute != null) {
                        fieldMapBuilder.put((Object)"tcp_route", (Object)this.tcpRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TCP_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "tcp_route", this.tcpRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TcpRouteName that = (TcpRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tcpRoute, that.tcpRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tcpRoute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tcpRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTcpRoute() {
            return this.tcpRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTcpRoute(String tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        private Builder(TcpRouteName tcpRouteName) {
            this.project = tcpRouteName.project;
            this.location = tcpRouteName.location;
            this.tcpRoute = tcpRouteName.tcpRoute;
        }

        public TcpRouteName build() {
            return new TcpRouteName(this);
        }
    }
}

