/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceLbPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_LB_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceLbPolicies/{service_lb_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceLbPolicy;

    @Deprecated
    protected ServiceLbPolicyName() {
        this.project = null;
        this.location = null;
        this.serviceLbPolicy = null;
    }

    private ServiceLbPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceLbPolicy = (String)Preconditions.checkNotNull((Object)builder.getServiceLbPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceLbPolicy() {
        return this.serviceLbPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceLbPolicyName of(String project, String location, String serviceLbPolicy) {
        return ServiceLbPolicyName.newBuilder().setProject(project).setLocation(location).setServiceLbPolicy(serviceLbPolicy).build();
    }

    public static String format(String project, String location, String serviceLbPolicy) {
        return ServiceLbPolicyName.newBuilder().setProject(project).setLocation(location).setServiceLbPolicy(serviceLbPolicy).build().toString();
    }

    public static ServiceLbPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_LB_POLICY.validatedMatch(formattedString, "ServiceLbPolicyName.parse: formattedString not in valid format");
        return ServiceLbPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_lb_policy"));
    }

    public static List<ServiceLbPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceLbPolicyName> list = new ArrayList<ServiceLbPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceLbPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceLbPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceLbPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_LB_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceLbPolicyName serviceLbPolicyName = this;
            synchronized (serviceLbPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceLbPolicy != null) {
                        fieldMapBuilder.put((Object)"service_lb_policy", (Object)this.serviceLbPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_LB_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "service_lb_policy", this.serviceLbPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceLbPolicyName that = (ServiceLbPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceLbPolicy, that.serviceLbPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceLbPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceLbPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceLbPolicy() {
            return this.serviceLbPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceLbPolicy(String serviceLbPolicy) {
            this.serviceLbPolicy = serviceLbPolicy;
            return this;
        }

        private Builder(ServiceLbPolicyName serviceLbPolicyName) {
            this.project = serviceLbPolicyName.project;
            this.location = serviceLbPolicyName.location;
            this.serviceLbPolicy = serviceLbPolicyName.serviceLbPolicy;
        }

        public ServiceLbPolicyName build() {
            return new ServiceLbPolicyName(this);
        }
    }
}

