/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LbRouteExtensionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LB_ROUTE_EXTENSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lbRouteExtensions/{lb_route_extension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lbRouteExtension;

    @Deprecated
    protected LbRouteExtensionName() {
        this.project = null;
        this.location = null;
        this.lbRouteExtension = null;
    }

    private LbRouteExtensionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lbRouteExtension = (String)Preconditions.checkNotNull((Object)builder.getLbRouteExtension());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLbRouteExtension() {
        return this.lbRouteExtension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LbRouteExtensionName of(String project, String location, String lbRouteExtension) {
        return LbRouteExtensionName.newBuilder().setProject(project).setLocation(location).setLbRouteExtension(lbRouteExtension).build();
    }

    public static String format(String project, String location, String lbRouteExtension) {
        return LbRouteExtensionName.newBuilder().setProject(project).setLocation(location).setLbRouteExtension(lbRouteExtension).build().toString();
    }

    public static LbRouteExtensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LB_ROUTE_EXTENSION.validatedMatch(formattedString, "LbRouteExtensionName.parse: formattedString not in valid format");
        return LbRouteExtensionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lb_route_extension"));
    }

    public static List<LbRouteExtensionName> parseList(List<String> formattedStrings) {
        ArrayList<LbRouteExtensionName> list = new ArrayList<LbRouteExtensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LbRouteExtensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LbRouteExtensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LbRouteExtensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LB_ROUTE_EXTENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LbRouteExtensionName lbRouteExtensionName = this;
            synchronized (lbRouteExtensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lbRouteExtension != null) {
                        fieldMapBuilder.put((Object)"lb_route_extension", (Object)this.lbRouteExtension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LB_ROUTE_EXTENSION.instantiate(new String[]{"project", this.project, "location", this.location, "lb_route_extension", this.lbRouteExtension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LbRouteExtensionName that = (LbRouteExtensionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lbRouteExtension, that.lbRouteExtension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lbRouteExtension);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lbRouteExtension;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLbRouteExtension() {
            return this.lbRouteExtension;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLbRouteExtension(String lbRouteExtension) {
            this.lbRouteExtension = lbRouteExtension;
            return this;
        }

        private Builder(LbRouteExtensionName lbRouteExtensionName) {
            this.project = lbRouteExtensionName.project;
            this.location = lbRouteExtensionName.location;
            this.lbRouteExtension = lbRouteExtensionName.lbRouteExtension;
        }

        public LbRouteExtensionName build() {
            return new LbRouteExtensionName(this);
        }
    }
}

