/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LbEdgeExtensionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LB_EDGE_EXTENSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lbEdgeExtensions/{lb_edge_extension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lbEdgeExtension;

    @Deprecated
    protected LbEdgeExtensionName() {
        this.project = null;
        this.location = null;
        this.lbEdgeExtension = null;
    }

    private LbEdgeExtensionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lbEdgeExtension = (String)Preconditions.checkNotNull((Object)builder.getLbEdgeExtension());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLbEdgeExtension() {
        return this.lbEdgeExtension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LbEdgeExtensionName of(String project, String location, String lbEdgeExtension) {
        return LbEdgeExtensionName.newBuilder().setProject(project).setLocation(location).setLbEdgeExtension(lbEdgeExtension).build();
    }

    public static String format(String project, String location, String lbEdgeExtension) {
        return LbEdgeExtensionName.newBuilder().setProject(project).setLocation(location).setLbEdgeExtension(lbEdgeExtension).build().toString();
    }

    public static LbEdgeExtensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LB_EDGE_EXTENSION.validatedMatch(formattedString, "LbEdgeExtensionName.parse: formattedString not in valid format");
        return LbEdgeExtensionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lb_edge_extension"));
    }

    public static List<LbEdgeExtensionName> parseList(List<String> formattedStrings) {
        ArrayList<LbEdgeExtensionName> list = new ArrayList<LbEdgeExtensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LbEdgeExtensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LbEdgeExtensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LbEdgeExtensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LB_EDGE_EXTENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LbEdgeExtensionName lbEdgeExtensionName = this;
            synchronized (lbEdgeExtensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lbEdgeExtension != null) {
                        fieldMapBuilder.put((Object)"lb_edge_extension", (Object)this.lbEdgeExtension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LB_EDGE_EXTENSION.instantiate(new String[]{"project", this.project, "location", this.location, "lb_edge_extension", this.lbEdgeExtension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LbEdgeExtensionName that = (LbEdgeExtensionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lbEdgeExtension, that.lbEdgeExtension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lbEdgeExtension);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lbEdgeExtension;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLbEdgeExtension() {
            return this.lbEdgeExtension;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLbEdgeExtension(String lbEdgeExtension) {
            this.lbEdgeExtension = lbEdgeExtension;
            return this;
        }

        private Builder(LbEdgeExtensionName lbEdgeExtensionName) {
            this.project = lbEdgeExtensionName.project;
            this.location = lbEdgeExtensionName.location;
            this.lbEdgeExtension = lbEdgeExtensionName.lbEdgeExtension;
        }

        public LbEdgeExtensionName build() {
            return new LbEdgeExtensionName(this);
        }
    }
}

