/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_HTTP_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/httpRoutes/{http_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String httpRoute;

    @Deprecated
    protected HttpRouteName() {
        this.project = null;
        this.location = null;
        this.httpRoute = null;
    }

    private HttpRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.httpRoute = (String)Preconditions.checkNotNull((Object)builder.getHttpRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getHttpRoute() {
        return this.httpRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HttpRouteName of(String project, String location, String httpRoute) {
        return HttpRouteName.newBuilder().setProject(project).setLocation(location).setHttpRoute(httpRoute).build();
    }

    public static String format(String project, String location, String httpRoute) {
        return HttpRouteName.newBuilder().setProject(project).setLocation(location).setHttpRoute(httpRoute).build().toString();
    }

    public static HttpRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_HTTP_ROUTE.validatedMatch(formattedString, "HttpRouteName.parse: formattedString not in valid format");
        return HttpRouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("http_route"));
    }

    public static List<HttpRouteName> parseList(List<String> formattedStrings) {
        ArrayList<HttpRouteName> list = new ArrayList<HttpRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HttpRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HttpRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HttpRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_HTTP_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HttpRouteName httpRouteName = this;
            synchronized (httpRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.httpRoute != null) {
                        fieldMapBuilder.put((Object)"http_route", (Object)this.httpRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_HTTP_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "http_route", this.httpRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HttpRouteName that = (HttpRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.httpRoute, that.httpRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.httpRoute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String httpRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getHttpRoute() {
            return this.httpRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setHttpRoute(String httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        private Builder(HttpRouteName httpRouteName) {
            this.project = httpRouteName.project;
            this.location = httpRouteName.location;
            this.httpRoute = httpRouteName.httpRoute;
        }

        public HttpRouteName build() {
            return new HttpRouteName(this);
        }
    }
}

