/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EndpointPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ENDPOINT_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/endpointPolicies/{endpoint_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String endpointPolicy;

    @Deprecated
    protected EndpointPolicyName() {
        this.project = null;
        this.location = null;
        this.endpointPolicy = null;
    }

    private EndpointPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.endpointPolicy = (String)Preconditions.checkNotNull((Object)builder.getEndpointPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEndpointPolicy() {
        return this.endpointPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EndpointPolicyName of(String project, String location, String endpointPolicy) {
        return EndpointPolicyName.newBuilder().setProject(project).setLocation(location).setEndpointPolicy(endpointPolicy).build();
    }

    public static String format(String project, String location, String endpointPolicy) {
        return EndpointPolicyName.newBuilder().setProject(project).setLocation(location).setEndpointPolicy(endpointPolicy).build().toString();
    }

    public static EndpointPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ENDPOINT_POLICY.validatedMatch(formattedString, "EndpointPolicyName.parse: formattedString not in valid format");
        return EndpointPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("endpoint_policy"));
    }

    public static List<EndpointPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<EndpointPolicyName> list = new ArrayList<EndpointPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EndpointPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EndpointPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EndpointPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ENDPOINT_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EndpointPolicyName endpointPolicyName = this;
            synchronized (endpointPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.endpointPolicy != null) {
                        fieldMapBuilder.put((Object)"endpoint_policy", (Object)this.endpointPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ENDPOINT_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "endpoint_policy", this.endpointPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EndpointPolicyName that = (EndpointPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.endpointPolicy, that.endpointPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.endpointPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String endpointPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getEndpointPolicy() {
            return this.endpointPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setEndpointPolicy(String endpointPolicy) {
            this.endpointPolicy = endpointPolicy;
            return this;
        }

        private Builder(EndpointPolicyName endpointPolicyName) {
            this.project = endpointPolicyName.project;
            this.location = endpointPolicyName.location;
            this.endpointPolicy = endpointPolicyName.endpointPolicy;
        }

        public EndpointPolicyName build() {
            return new EndpointPolicyName(this);
        }
    }
}

