/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthzExtensionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTHZ_EXTENSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/authzExtensions/{authz_extension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String authzExtension;

    @Deprecated
    protected AuthzExtensionName() {
        this.project = null;
        this.location = null;
        this.authzExtension = null;
    }

    private AuthzExtensionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.authzExtension = (String)Preconditions.checkNotNull((Object)builder.getAuthzExtension());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAuthzExtension() {
        return this.authzExtension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AuthzExtensionName of(String project, String location, String authzExtension) {
        return AuthzExtensionName.newBuilder().setProject(project).setLocation(location).setAuthzExtension(authzExtension).build();
    }

    public static String format(String project, String location, String authzExtension) {
        return AuthzExtensionName.newBuilder().setProject(project).setLocation(location).setAuthzExtension(authzExtension).build().toString();
    }

    public static AuthzExtensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AUTHZ_EXTENSION.validatedMatch(formattedString, "AuthzExtensionName.parse: formattedString not in valid format");
        return AuthzExtensionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("authz_extension"));
    }

    public static List<AuthzExtensionName> parseList(List<String> formattedStrings) {
        ArrayList<AuthzExtensionName> list = new ArrayList<AuthzExtensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AuthzExtensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AuthzExtensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AuthzExtensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTHZ_EXTENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AuthzExtensionName authzExtensionName = this;
            synchronized (authzExtensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.authzExtension != null) {
                        fieldMapBuilder.put((Object)"authz_extension", (Object)this.authzExtension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AUTHZ_EXTENSION.instantiate(new String[]{"project", this.project, "location", this.location, "authz_extension", this.authzExtension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AuthzExtensionName that = (AuthzExtensionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.authzExtension, that.authzExtension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authzExtension);
    }

    public static class Builder {
        private String project;
        private String location;
        private String authzExtension;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAuthzExtension() {
            return this.authzExtension;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAuthzExtension(String authzExtension) {
            this.authzExtension = authzExtension;
            return this;
        }

        private Builder(AuthzExtensionName authzExtensionName) {
            this.project = authzExtensionName.project;
            this.location = authzExtensionName.location;
            this.authzExtension = authzExtensionName.authzExtension;
        }

        public AuthzExtensionName build() {
            return new AuthzExtensionName(this);
        }
    }
}

