/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GatewayRouteViewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GATEWAY_ROUTE_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/gateways/{gateway}/routeViews/{route_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String gateway;
    private final String routeView;

    @Deprecated
    protected GatewayRouteViewName() {
        this.project = null;
        this.location = null;
        this.gateway = null;
        this.routeView = null;
    }

    private GatewayRouteViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.gateway = (String)Preconditions.checkNotNull((Object)builder.getGateway());
        this.routeView = (String)Preconditions.checkNotNull((Object)builder.getRouteView());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getRouteView() {
        return this.routeView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GatewayRouteViewName of(String project, String location, String gateway, String routeView) {
        return GatewayRouteViewName.newBuilder().setProject(project).setLocation(location).setGateway(gateway).setRouteView(routeView).build();
    }

    public static String format(String project, String location, String gateway, String routeView) {
        return GatewayRouteViewName.newBuilder().setProject(project).setLocation(location).setGateway(gateway).setRouteView(routeView).build().toString();
    }

    public static GatewayRouteViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GATEWAY_ROUTE_VIEW.validatedMatch(formattedString, "GatewayRouteViewName.parse: formattedString not in valid format");
        return GatewayRouteViewName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("gateway"), (String)matchMap.get("route_view"));
    }

    public static List<GatewayRouteViewName> parseList(List<String> formattedStrings) {
        ArrayList<GatewayRouteViewName> list = new ArrayList<GatewayRouteViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GatewayRouteViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GatewayRouteViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GatewayRouteViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GATEWAY_ROUTE_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GatewayRouteViewName gatewayRouteViewName = this;
            synchronized (gatewayRouteViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.gateway != null) {
                        fieldMapBuilder.put((Object)"gateway", (Object)this.gateway);
                    }
                    if (this.routeView != null) {
                        fieldMapBuilder.put((Object)"route_view", (Object)this.routeView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GATEWAY_ROUTE_VIEW.instantiate(new String[]{"project", this.project, "location", this.location, "gateway", this.gateway, "route_view", this.routeView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GatewayRouteViewName that = (GatewayRouteViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.gateway, that.gateway) && Objects.equals(this.routeView, that.routeView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.gateway);
        h *= 1000003;
        return h ^= Objects.hashCode(this.routeView);
    }

    public static class Builder {
        private String project;
        private String location;
        private String gateway;
        private String routeView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getRouteView() {
            return this.routeView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder setRouteView(String routeView) {
            this.routeView = routeView;
            return this;
        }

        private Builder(GatewayRouteViewName gatewayRouteViewName) {
            this.project = gatewayRouteViewName.project;
            this.location = gatewayRouteViewName.location;
            this.gateway = gatewayRouteViewName.gateway;
            this.routeView = gatewayRouteViewName.routeView;
        }

        public GatewayRouteViewName build() {
            return new GatewayRouteViewName(this);
        }
    }
}

