/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MeshRouteViewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MESH_ROUTE_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/meshes/{mesh}/routeViews/{route_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String mesh;
    private final String routeView;

    @Deprecated
    protected MeshRouteViewName() {
        this.project = null;
        this.location = null;
        this.mesh = null;
        this.routeView = null;
    }

    private MeshRouteViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.mesh = (String)Preconditions.checkNotNull((Object)builder.getMesh());
        this.routeView = (String)Preconditions.checkNotNull((Object)builder.getRouteView());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMesh() {
        return this.mesh;
    }

    public String getRouteView() {
        return this.routeView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MeshRouteViewName of(String project, String location, String mesh, String routeView) {
        return MeshRouteViewName.newBuilder().setProject(project).setLocation(location).setMesh(mesh).setRouteView(routeView).build();
    }

    public static String format(String project, String location, String mesh, String routeView) {
        return MeshRouteViewName.newBuilder().setProject(project).setLocation(location).setMesh(mesh).setRouteView(routeView).build().toString();
    }

    public static MeshRouteViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MESH_ROUTE_VIEW.validatedMatch(formattedString, "MeshRouteViewName.parse: formattedString not in valid format");
        return MeshRouteViewName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("mesh"), (String)matchMap.get("route_view"));
    }

    public static List<MeshRouteViewName> parseList(List<String> formattedStrings) {
        ArrayList<MeshRouteViewName> list = new ArrayList<MeshRouteViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MeshRouteViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MeshRouteViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MeshRouteViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MESH_ROUTE_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MeshRouteViewName meshRouteViewName = this;
            synchronized (meshRouteViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.mesh != null) {
                        fieldMapBuilder.put((Object)"mesh", (Object)this.mesh);
                    }
                    if (this.routeView != null) {
                        fieldMapBuilder.put((Object)"route_view", (Object)this.routeView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MESH_ROUTE_VIEW.instantiate(new String[]{"project", this.project, "location", this.location, "mesh", this.mesh, "route_view", this.routeView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MeshRouteViewName that = (MeshRouteViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.mesh, that.mesh) && Objects.equals(this.routeView, that.routeView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.mesh);
        h *= 1000003;
        return h ^= Objects.hashCode(this.routeView);
    }

    public static class Builder {
        private String project;
        private String location;
        private String mesh;
        private String routeView;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMesh() {
            return this.mesh;
        }

        public String getRouteView() {
            return this.routeView;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMesh(String mesh) {
            this.mesh = mesh;
            return this;
        }

        public Builder setRouteView(String routeView) {
            this.routeView = routeView;
            return this;
        }

        private Builder(MeshRouteViewName meshRouteViewName) {
            this.project = meshRouteViewName.project;
            this.location = meshRouteViewName.location;
            this.mesh = meshRouteViewName.mesh;
            this.routeView = meshRouteViewName.routeView;
        }

        public MeshRouteViewName build() {
            return new MeshRouteViewName(this);
        }
    }
}

