/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TlsRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TLS_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tlsRoutes/{tls_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tlsRoute;

    @Deprecated
    protected TlsRouteName() {
        this.project = null;
        this.location = null;
        this.tlsRoute = null;
    }

    private TlsRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tlsRoute = (String)Preconditions.checkNotNull((Object)builder.getTlsRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTlsRoute() {
        return this.tlsRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TlsRouteName of(String project, String location, String tlsRoute) {
        return TlsRouteName.newBuilder().setProject(project).setLocation(location).setTlsRoute(tlsRoute).build();
    }

    public static String format(String project, String location, String tlsRoute) {
        return TlsRouteName.newBuilder().setProject(project).setLocation(location).setTlsRoute(tlsRoute).build().toString();
    }

    public static TlsRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TLS_ROUTE.validatedMatch(formattedString, "TlsRouteName.parse: formattedString not in valid format");
        return TlsRouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tls_route"));
    }

    public static List<TlsRouteName> parseList(List<String> formattedStrings) {
        ArrayList<TlsRouteName> list = new ArrayList<TlsRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TlsRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TlsRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TlsRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TLS_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TlsRouteName tlsRouteName = this;
            synchronized (tlsRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tlsRoute != null) {
                        fieldMapBuilder.put((Object)"tls_route", (Object)this.tlsRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TLS_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "tls_route", this.tlsRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TlsRouteName that = (TlsRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tlsRoute, that.tlsRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tlsRoute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tlsRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTlsRoute() {
            return this.tlsRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTlsRoute(String tlsRoute) {
            this.tlsRoute = tlsRoute;
            return this;
        }

        private Builder(TlsRouteName tlsRouteName) {
            this.project = tlsRouteName.project;
            this.location = tlsRouteName.location;
            this.tlsRoute = tlsRouteName.tlsRoute;
        }

        public TlsRouteName build() {
            return new TlsRouteName(this);
        }
    }
}

