/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LbTrafficExtensionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_LB_TRAFFIC_EXTENSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/lbTrafficExtensions/{lb_traffic_extension}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String lbTrafficExtension;

    @Deprecated
    protected LbTrafficExtensionName() {
        this.project = null;
        this.location = null;
        this.lbTrafficExtension = null;
    }

    private LbTrafficExtensionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.lbTrafficExtension = (String)Preconditions.checkNotNull((Object)builder.getLbTrafficExtension());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLbTrafficExtension() {
        return this.lbTrafficExtension;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LbTrafficExtensionName of(String project, String location, String lbTrafficExtension) {
        return LbTrafficExtensionName.newBuilder().setProject(project).setLocation(location).setLbTrafficExtension(lbTrafficExtension).build();
    }

    public static String format(String project, String location, String lbTrafficExtension) {
        return LbTrafficExtensionName.newBuilder().setProject(project).setLocation(location).setLbTrafficExtension(lbTrafficExtension).build().toString();
    }

    public static LbTrafficExtensionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_LB_TRAFFIC_EXTENSION.validatedMatch(formattedString, "LbTrafficExtensionName.parse: formattedString not in valid format");
        return LbTrafficExtensionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("lb_traffic_extension"));
    }

    public static List<LbTrafficExtensionName> parseList(List<String> formattedStrings) {
        ArrayList<LbTrafficExtensionName> list = new ArrayList<LbTrafficExtensionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LbTrafficExtensionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LbTrafficExtensionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LbTrafficExtensionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_LB_TRAFFIC_EXTENSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LbTrafficExtensionName lbTrafficExtensionName = this;
            synchronized (lbTrafficExtensionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.lbTrafficExtension != null) {
                        fieldMapBuilder.put((Object)"lb_traffic_extension", (Object)this.lbTrafficExtension);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_LB_TRAFFIC_EXTENSION.instantiate(new String[]{"project", this.project, "location", this.location, "lb_traffic_extension", this.lbTrafficExtension});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            LbTrafficExtensionName that = (LbTrafficExtensionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.lbTrafficExtension, that.lbTrafficExtension);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lbTrafficExtension);
    }

    public static class Builder {
        private String project;
        private String location;
        private String lbTrafficExtension;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLbTrafficExtension() {
            return this.lbTrafficExtension;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setLbTrafficExtension(String lbTrafficExtension) {
            this.lbTrafficExtension = lbTrafficExtension;
            return this;
        }

        private Builder(LbTrafficExtensionName lbTrafficExtensionName) {
            this.project = lbTrafficExtensionName.project;
            this.location = lbTrafficExtensionName.location;
            this.lbTrafficExtension = lbTrafficExtensionName.lbTrafficExtension;
        }

        public LbTrafficExtensionName build() {
            return new LbTrafficExtensionName(this);
        }
    }
}

