/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GrpcRouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GRPC_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/grpcRoutes/{grpc_route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String grpcRoute;

    @Deprecated
    protected GrpcRouteName() {
        this.project = null;
        this.location = null;
        this.grpcRoute = null;
    }

    private GrpcRouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.grpcRoute = (String)Preconditions.checkNotNull((Object)builder.getGrpcRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGrpcRoute() {
        return this.grpcRoute;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GrpcRouteName of(String project, String location, String grpcRoute) {
        return GrpcRouteName.newBuilder().setProject(project).setLocation(location).setGrpcRoute(grpcRoute).build();
    }

    public static String format(String project, String location, String grpcRoute) {
        return GrpcRouteName.newBuilder().setProject(project).setLocation(location).setGrpcRoute(grpcRoute).build().toString();
    }

    public static GrpcRouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GRPC_ROUTE.validatedMatch(formattedString, "GrpcRouteName.parse: formattedString not in valid format");
        return GrpcRouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("grpc_route"));
    }

    public static List<GrpcRouteName> parseList(List<String> formattedStrings) {
        ArrayList<GrpcRouteName> list = new ArrayList<GrpcRouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GrpcRouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GrpcRouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GrpcRouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GRPC_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GrpcRouteName grpcRouteName = this;
            synchronized (grpcRouteName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.grpcRoute != null) {
                        fieldMapBuilder.put((Object)"grpc_route", (Object)this.grpcRoute);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GRPC_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "grpc_route", this.grpcRoute});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GrpcRouteName that = (GrpcRouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.grpcRoute, that.grpcRoute);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.grpcRoute);
    }

    public static class Builder {
        private String project;
        private String location;
        private String grpcRoute;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGrpcRoute() {
            return this.grpcRoute;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGrpcRoute(String grpcRoute) {
            this.grpcRoute = grpcRoute;
            return this;
        }

        private Builder(GrpcRouteName grpcRouteName) {
            this.project = grpcRouteName.project;
            this.location = grpcRouteName.location;
            this.grpcRoute = grpcRouteName.grpcRoute;
        }

        public GrpcRouteName build() {
            return new GrpcRouteName(this);
        }
    }
}

