/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceBindingName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_BINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceBindings/{service_binding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceBinding;

    @Deprecated
    protected ServiceBindingName() {
        this.project = null;
        this.location = null;
        this.serviceBinding = null;
    }

    private ServiceBindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceBinding = (String)Preconditions.checkNotNull((Object)builder.getServiceBinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceBinding() {
        return this.serviceBinding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceBindingName of(String project, String location, String serviceBinding) {
        return ServiceBindingName.newBuilder().setProject(project).setLocation(location).setServiceBinding(serviceBinding).build();
    }

    public static String format(String project, String location, String serviceBinding) {
        return ServiceBindingName.newBuilder().setProject(project).setLocation(location).setServiceBinding(serviceBinding).build().toString();
    }

    public static ServiceBindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_BINDING.validatedMatch(formattedString, "ServiceBindingName.parse: formattedString not in valid format");
        return ServiceBindingName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_binding"));
    }

    public static List<ServiceBindingName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceBindingName> list = new ArrayList<ServiceBindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceBindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceBindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceBindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_BINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceBindingName serviceBindingName = this;
            synchronized (serviceBindingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceBinding != null) {
                        fieldMapBuilder.put((Object)"service_binding", (Object)this.serviceBinding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_BINDING.instantiate(new String[]{"project", this.project, "location", this.location, "service_binding", this.serviceBinding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceBindingName that = (ServiceBindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceBinding, that.serviceBinding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceBinding);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceBinding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceBinding() {
            return this.serviceBinding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceBinding(String serviceBinding) {
            this.serviceBinding = serviceBinding;
            return this;
        }

        private Builder(ServiceBindingName serviceBindingName) {
            this.project = serviceBindingName.project;
            this.location = serviceBindingName.location;
            this.serviceBinding = serviceBindingName.serviceBinding;
        }

        public ServiceBindingName build() {
            return new ServiceBindingName(this);
        }
    }
}

