/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkservices.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MeshName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MESH = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/meshes/{mesh}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String mesh;

    @Deprecated
    protected MeshName() {
        this.project = null;
        this.location = null;
        this.mesh = null;
    }

    private MeshName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.mesh = (String)Preconditions.checkNotNull((Object)builder.getMesh());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMesh() {
        return this.mesh;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MeshName of(String project, String location, String mesh) {
        return MeshName.newBuilder().setProject(project).setLocation(location).setMesh(mesh).build();
    }

    public static String format(String project, String location, String mesh) {
        return MeshName.newBuilder().setProject(project).setLocation(location).setMesh(mesh).build().toString();
    }

    public static MeshName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MESH.validatedMatch(formattedString, "MeshName.parse: formattedString not in valid format");
        return MeshName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("mesh"));
    }

    public static List<MeshName> parseList(List<String> formattedStrings) {
        ArrayList<MeshName> list = new ArrayList<MeshName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MeshName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MeshName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MeshName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MESH.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MeshName meshName = this;
            synchronized (meshName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.mesh != null) {
                        fieldMapBuilder.put((Object)"mesh", (Object)this.mesh);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MESH.instantiate(new String[]{"project", this.project, "location", this.location, "mesh", this.mesh});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MeshName that = (MeshName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.mesh, that.mesh);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.mesh);
    }

    public static class Builder {
        private String project;
        private String location;
        private String mesh;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMesh() {
            return this.mesh;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMesh(String mesh) {
            this.mesh = mesh;
            return this;
        }

        private Builder(MeshName meshName) {
            this.project = meshName.project;
            this.location = meshName.location;
            this.mesh = meshName.mesh;
        }

        public MeshName build() {
            return new MeshName(this);
        }
    }
}

