/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HubName
implements ResourceName {
    private static final PathTemplate PROJECT_HUB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/global/hubs/{hub}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String hub;

    @Deprecated
    protected HubName() {
        this.project = null;
        this.hub = null;
    }

    private HubName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.hub = (String)Preconditions.checkNotNull((Object)builder.getHub());
    }

    public String getProject() {
        return this.project;
    }

    public String getHub() {
        return this.hub;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HubName of(String project, String hub) {
        return HubName.newBuilder().setProject(project).setHub(hub).build();
    }

    public static String format(String project, String hub) {
        return HubName.newBuilder().setProject(project).setHub(hub).build().toString();
    }

    public static HubName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_HUB.validatedMatch(formattedString, "HubName.parse: formattedString not in valid format");
        return HubName.of((String)matchMap.get("project"), (String)matchMap.get("hub"));
    }

    public static List<HubName> parseList(List<String> formattedStrings) {
        ArrayList<HubName> list = new ArrayList<HubName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HubName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HubName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HubName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_HUB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HubName hubName = this;
            synchronized (hubName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.hub != null) {
                        fieldMapBuilder.put((Object)"hub", (Object)this.hub);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_HUB.instantiate(new String[]{"project", this.project, "hub", this.hub});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            HubName that = (HubName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.hub, that.hub);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hub);
    }

    public static class Builder {
        private String project;
        private String hub;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getHub() {
            return this.hub;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setHub(String hub) {
            this.hub = hub;
            return this;
        }

        private Builder(HubName hubName) {
            this.project = hubName.project;
            this.hub = hubName.hub;
        }

        public HubName build() {
            return new HubName(this);
        }
    }
}

