/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceConnectionPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SERVICE_CONNECTION_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/serviceConnectionPolicies/{service_connection_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String serviceConnectionPolicy;

    @Deprecated
    protected ServiceConnectionPolicyName() {
        this.project = null;
        this.location = null;
        this.serviceConnectionPolicy = null;
    }

    private ServiceConnectionPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.serviceConnectionPolicy = (String)Preconditions.checkNotNull((Object)builder.getServiceConnectionPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getServiceConnectionPolicy() {
        return this.serviceConnectionPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServiceConnectionPolicyName of(String project, String location, String serviceConnectionPolicy) {
        return ServiceConnectionPolicyName.newBuilder().setProject(project).setLocation(location).setServiceConnectionPolicy(serviceConnectionPolicy).build();
    }

    public static String format(String project, String location, String serviceConnectionPolicy) {
        return ServiceConnectionPolicyName.newBuilder().setProject(project).setLocation(location).setServiceConnectionPolicy(serviceConnectionPolicy).build().toString();
    }

    public static ServiceConnectionPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SERVICE_CONNECTION_POLICY.validatedMatch(formattedString, "ServiceConnectionPolicyName.parse: formattedString not in valid format");
        return ServiceConnectionPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("service_connection_policy"));
    }

    public static List<ServiceConnectionPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<ServiceConnectionPolicyName> list = new ArrayList<ServiceConnectionPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServiceConnectionPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServiceConnectionPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServiceConnectionPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SERVICE_CONNECTION_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServiceConnectionPolicyName serviceConnectionPolicyName = this;
            synchronized (serviceConnectionPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.serviceConnectionPolicy != null) {
                        fieldMapBuilder.put((Object)"service_connection_policy", (Object)this.serviceConnectionPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SERVICE_CONNECTION_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "service_connection_policy", this.serviceConnectionPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServiceConnectionPolicyName that = (ServiceConnectionPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.serviceConnectionPolicy, that.serviceConnectionPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.serviceConnectionPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String serviceConnectionPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getServiceConnectionPolicy() {
            return this.serviceConnectionPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setServiceConnectionPolicy(String serviceConnectionPolicy) {
            this.serviceConnectionPolicy = serviceConnectionPolicy;
            return this;
        }

        private Builder(ServiceConnectionPolicyName serviceConnectionPolicyName) {
            this.project = serviceConnectionPolicyName.project;
            this.location = serviceConnectionPolicyName.location;
            this.serviceConnectionPolicy = serviceConnectionPolicyName.serviceConnectionPolicy;
        }

        public ServiceConnectionPolicyName build() {
            return new ServiceConnectionPolicyName(this);
        }
    }
}

