/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MulticloudDataTransferConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/multicloudDataTransferConfigs/{multicloud_data_transfer_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String multicloudDataTransferConfig;

    @Deprecated
    protected MulticloudDataTransferConfigName() {
        this.project = null;
        this.location = null;
        this.multicloudDataTransferConfig = null;
    }

    private MulticloudDataTransferConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.multicloudDataTransferConfig = (String)Preconditions.checkNotNull((Object)builder.getMulticloudDataTransferConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMulticloudDataTransferConfig() {
        return this.multicloudDataTransferConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MulticloudDataTransferConfigName of(String project, String location, String multicloudDataTransferConfig) {
        return MulticloudDataTransferConfigName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferConfig(multicloudDataTransferConfig).build();
    }

    public static String format(String project, String location, String multicloudDataTransferConfig) {
        return MulticloudDataTransferConfigName.newBuilder().setProject(project).setLocation(location).setMulticloudDataTransferConfig(multicloudDataTransferConfig).build().toString();
    }

    public static MulticloudDataTransferConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG.validatedMatch(formattedString, "MulticloudDataTransferConfigName.parse: formattedString not in valid format");
        return MulticloudDataTransferConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("multicloud_data_transfer_config"));
    }

    public static List<MulticloudDataTransferConfigName> parseList(List<String> formattedStrings) {
        ArrayList<MulticloudDataTransferConfigName> list = new ArrayList<MulticloudDataTransferConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MulticloudDataTransferConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MulticloudDataTransferConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MulticloudDataTransferConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MulticloudDataTransferConfigName multicloudDataTransferConfigName = this;
            synchronized (multicloudDataTransferConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.multicloudDataTransferConfig != null) {
                        fieldMapBuilder.put((Object)"multicloud_data_transfer_config", (Object)this.multicloudDataTransferConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MULTICLOUD_DATA_TRANSFER_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "multicloud_data_transfer_config", this.multicloudDataTransferConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MulticloudDataTransferConfigName that = (MulticloudDataTransferConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.multicloudDataTransferConfig, that.multicloudDataTransferConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.multicloudDataTransferConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String multicloudDataTransferConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getMulticloudDataTransferConfig() {
            return this.multicloudDataTransferConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setMulticloudDataTransferConfig(String multicloudDataTransferConfig) {
            this.multicloudDataTransferConfig = multicloudDataTransferConfig;
            return this;
        }

        private Builder(MulticloudDataTransferConfigName multicloudDataTransferConfigName) {
            this.project = multicloudDataTransferConfigName.project;
            this.location = multicloudDataTransferConfigName.location;
            this.multicloudDataTransferConfig = multicloudDataTransferConfigName.multicloudDataTransferConfig;
        }

        public MulticloudDataTransferConfigName build() {
            return new MulticloudDataTransferConfigName(this);
        }
    }
}

