/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InternalRangeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INTERNAL_RANGE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/internalRanges/{internal_range}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String internalRange;

    @Deprecated
    protected InternalRangeName() {
        this.project = null;
        this.location = null;
        this.internalRange = null;
    }

    private InternalRangeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.internalRange = (String)Preconditions.checkNotNull((Object)builder.getInternalRange());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInternalRange() {
        return this.internalRange;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InternalRangeName of(String project, String location, String internalRange) {
        return InternalRangeName.newBuilder().setProject(project).setLocation(location).setInternalRange(internalRange).build();
    }

    public static String format(String project, String location, String internalRange) {
        return InternalRangeName.newBuilder().setProject(project).setLocation(location).setInternalRange(internalRange).build().toString();
    }

    public static InternalRangeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INTERNAL_RANGE.validatedMatch(formattedString, "InternalRangeName.parse: formattedString not in valid format");
        return InternalRangeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("internal_range"));
    }

    public static List<InternalRangeName> parseList(List<String> formattedStrings) {
        ArrayList<InternalRangeName> list = new ArrayList<InternalRangeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InternalRangeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InternalRangeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InternalRangeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INTERNAL_RANGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InternalRangeName internalRangeName = this;
            synchronized (internalRangeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.internalRange != null) {
                        fieldMapBuilder.put((Object)"internal_range", (Object)this.internalRange);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INTERNAL_RANGE.instantiate(new String[]{"project", this.project, "location", this.location, "internal_range", this.internalRange});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            InternalRangeName that = (InternalRangeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.internalRange, that.internalRange);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.internalRange);
    }

    public static class Builder {
        private String project;
        private String location;
        private String internalRange;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInternalRange() {
            return this.internalRange;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInternalRange(String internalRange) {
            this.internalRange = internalRange;
            return this;
        }

        private Builder(InternalRangeName internalRangeName) {
            this.project = internalRangeName.project;
            this.location = internalRangeName.location;
            this.internalRange = internalRangeName.internalRange;
        }

        public InternalRangeName build() {
            return new InternalRangeName(this);
        }
    }
}

