/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClientTlsPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CLIENT_TLS_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/clientTlsPolicies/{client_tls_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String clientTlsPolicy;

    @Deprecated
    protected ClientTlsPolicyName() {
        this.project = null;
        this.location = null;
        this.clientTlsPolicy = null;
    }

    private ClientTlsPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.clientTlsPolicy = (String)Preconditions.checkNotNull((Object)builder.getClientTlsPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getClientTlsPolicy() {
        return this.clientTlsPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ClientTlsPolicyName of(String project, String location, String clientTlsPolicy) {
        return ClientTlsPolicyName.newBuilder().setProject(project).setLocation(location).setClientTlsPolicy(clientTlsPolicy).build();
    }

    public static String format(String project, String location, String clientTlsPolicy) {
        return ClientTlsPolicyName.newBuilder().setProject(project).setLocation(location).setClientTlsPolicy(clientTlsPolicy).build().toString();
    }

    public static ClientTlsPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CLIENT_TLS_POLICY.validatedMatch(formattedString, "ClientTlsPolicyName.parse: formattedString not in valid format");
        return ClientTlsPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("client_tls_policy"));
    }

    public static List<ClientTlsPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<ClientTlsPolicyName> list = new ArrayList<ClientTlsPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClientTlsPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClientTlsPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClientTlsPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CLIENT_TLS_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClientTlsPolicyName clientTlsPolicyName = this;
            synchronized (clientTlsPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.clientTlsPolicy != null) {
                        fieldMapBuilder.put((Object)"client_tls_policy", (Object)this.clientTlsPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CLIENT_TLS_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "client_tls_policy", this.clientTlsPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ClientTlsPolicyName that = (ClientTlsPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.clientTlsPolicy, that.clientTlsPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.clientTlsPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String clientTlsPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getClientTlsPolicy() {
            return this.clientTlsPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setClientTlsPolicy(String clientTlsPolicy) {
            this.clientTlsPolicy = clientTlsPolicy;
            return this;
        }

        private Builder(ClientTlsPolicyName clientTlsPolicyName) {
            this.project = clientTlsPolicyName.project;
            this.location = clientTlsPolicyName.location;
            this.clientTlsPolicy = clientTlsPolicyName.clientTlsPolicy;
        }

        public ClientTlsPolicyName build() {
            return new ClientTlsPolicyName(this);
        }
    }
}

