/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuthorizationPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_AUTHORIZATION_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/authorizationPolicies/{authorization_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String authorizationPolicy;

    @Deprecated
    protected AuthorizationPolicyName() {
        this.project = null;
        this.location = null;
        this.authorizationPolicy = null;
    }

    private AuthorizationPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.authorizationPolicy = (String)Preconditions.checkNotNull((Object)builder.getAuthorizationPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAuthorizationPolicy() {
        return this.authorizationPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AuthorizationPolicyName of(String project, String location, String authorizationPolicy) {
        return AuthorizationPolicyName.newBuilder().setProject(project).setLocation(location).setAuthorizationPolicy(authorizationPolicy).build();
    }

    public static String format(String project, String location, String authorizationPolicy) {
        return AuthorizationPolicyName.newBuilder().setProject(project).setLocation(location).setAuthorizationPolicy(authorizationPolicy).build().toString();
    }

    public static AuthorizationPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_AUTHORIZATION_POLICY.validatedMatch(formattedString, "AuthorizationPolicyName.parse: formattedString not in valid format");
        return AuthorizationPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("authorization_policy"));
    }

    public static List<AuthorizationPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AuthorizationPolicyName> list = new ArrayList<AuthorizationPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AuthorizationPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AuthorizationPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AuthorizationPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_AUTHORIZATION_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AuthorizationPolicyName authorizationPolicyName = this;
            synchronized (authorizationPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.authorizationPolicy != null) {
                        fieldMapBuilder.put((Object)"authorization_policy", (Object)this.authorizationPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_AUTHORIZATION_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "authorization_policy", this.authorizationPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AuthorizationPolicyName that = (AuthorizationPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.authorizationPolicy, that.authorizationPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authorizationPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String authorizationPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAuthorizationPolicy() {
            return this.authorizationPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAuthorizationPolicy(String authorizationPolicy) {
            this.authorizationPolicy = authorizationPolicy;
            return this;
        }

        private Builder(AuthorizationPolicyName authorizationPolicyName) {
            this.project = authorizationPolicyName.project;
            this.location = authorizationPolicyName.location;
            this.authorizationPolicy = authorizationPolicyName.authorizationPolicy;
        }

        public AuthorizationPolicyName build() {
            return new AuthorizationPolicyName(this);
        }
    }
}

