/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.cloud.netapp.v1.HybridReplicationParametersOrBuilder;
import com.google.cloud.netapp.v1.HybridReplicationSchedule;
import com.google.cloud.netapp.v1.VolumeProto;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.MapEntry;
import com.google.protobuf.MapField;
import com.google.protobuf.MapFieldReflectionAccessor;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class HybridReplicationParameters
extends GeneratedMessageV3
implements HybridReplicationParametersOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int REPLICATION_FIELD_NUMBER = 1;
    private volatile Object replication_ = "";
    public static final int PEER_VOLUME_NAME_FIELD_NUMBER = 2;
    private volatile Object peerVolumeName_ = "";
    public static final int PEER_CLUSTER_NAME_FIELD_NUMBER = 3;
    private volatile Object peerClusterName_ = "";
    public static final int PEER_SVM_NAME_FIELD_NUMBER = 4;
    private volatile Object peerSvmName_ = "";
    public static final int PEER_IP_ADDRESSES_FIELD_NUMBER = 5;
    private LazyStringArrayList peerIpAddresses_ = LazyStringArrayList.emptyList();
    public static final int CLUSTER_LOCATION_FIELD_NUMBER = 6;
    private volatile Object clusterLocation_ = "";
    public static final int DESCRIPTION_FIELD_NUMBER = 7;
    private volatile Object description_ = "";
    public static final int LABELS_FIELD_NUMBER = 8;
    private MapField<String, String> labels_;
    public static final int REPLICATION_SCHEDULE_FIELD_NUMBER = 9;
    private int replicationSchedule_ = 0;
    public static final int HYBRID_REPLICATION_TYPE_FIELD_NUMBER = 10;
    private int hybridReplicationType_ = 0;
    public static final int LARGE_VOLUME_CONSTITUENT_COUNT_FIELD_NUMBER = 11;
    private int largeVolumeConstituentCount_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final HybridReplicationParameters DEFAULT_INSTANCE = new HybridReplicationParameters();
    private static final Parser<HybridReplicationParameters> PARSER = new AbstractParser<HybridReplicationParameters>(){

        public HybridReplicationParameters parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = HybridReplicationParameters.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private HybridReplicationParameters(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private HybridReplicationParameters() {
        this.replication_ = "";
        this.peerVolumeName_ = "";
        this.peerClusterName_ = "";
        this.peerSvmName_ = "";
        this.peerIpAddresses_ = LazyStringArrayList.emptyList();
        this.clusterLocation_ = "";
        this.description_ = "";
        this.replicationSchedule_ = 0;
        this.hybridReplicationType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new HybridReplicationParameters();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_descriptor;
    }

    protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
        switch (number) {
            case 8: {
                return this.internalGetLabels();
            }
        }
        throw new RuntimeException("Invalid map field number: " + number);
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_fieldAccessorTable.ensureFieldAccessorsInitialized(HybridReplicationParameters.class, Builder.class);
    }

    @Override
    public String getReplication() {
        Object ref = this.replication_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.replication_ = s;
        return s;
    }

    @Override
    public ByteString getReplicationBytes() {
        Object ref = this.replication_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.replication_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPeerVolumeName() {
        Object ref = this.peerVolumeName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.peerVolumeName_ = s;
        return s;
    }

    @Override
    public ByteString getPeerVolumeNameBytes() {
        Object ref = this.peerVolumeName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.peerVolumeName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPeerClusterName() {
        Object ref = this.peerClusterName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.peerClusterName_ = s;
        return s;
    }

    @Override
    public ByteString getPeerClusterNameBytes() {
        Object ref = this.peerClusterName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.peerClusterName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getPeerSvmName() {
        Object ref = this.peerSvmName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.peerSvmName_ = s;
        return s;
    }

    @Override
    public ByteString getPeerSvmNameBytes() {
        Object ref = this.peerSvmName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.peerSvmName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public ProtocolStringList getPeerIpAddressesList() {
        return this.peerIpAddresses_;
    }

    @Override
    public int getPeerIpAddressesCount() {
        return this.peerIpAddresses_.size();
    }

    @Override
    public String getPeerIpAddresses(int index) {
        return this.peerIpAddresses_.get(index);
    }

    @Override
    public ByteString getPeerIpAddressesBytes(int index) {
        return this.peerIpAddresses_.getByteString(index);
    }

    @Override
    public String getClusterLocation() {
        Object ref = this.clusterLocation_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.clusterLocation_ = s;
        return s;
    }

    @Override
    public ByteString getClusterLocationBytes() {
        Object ref = this.clusterLocation_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.clusterLocation_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getDescription() {
        Object ref = this.description_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.description_ = s;
        return s;
    }

    @Override
    public ByteString getDescriptionBytes() {
        Object ref = this.description_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.description_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    private MapField<String, String> internalGetLabels() {
        if (this.labels_ == null) {
            return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
        }
        return this.labels_;
    }

    @Override
    public int getLabelsCount() {
        return this.internalGetLabels().getMap().size();
    }

    @Override
    public boolean containsLabels(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        return this.internalGetLabels().getMap().containsKey(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getLabels() {
        return this.getLabelsMap();
    }

    @Override
    public Map<String, String> getLabelsMap() {
        return this.internalGetLabels().getMap();
    }

    @Override
    public String getLabelsOrDefault(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        return map.containsKey(key) ? (String)map.get(key) : defaultValue;
    }

    @Override
    public String getLabelsOrThrow(String key) {
        if (key == null) {
            throw new NullPointerException("map key");
        }
        Map map = this.internalGetLabels().getMap();
        if (!map.containsKey(key)) {
            throw new IllegalArgumentException();
        }
        return (String)map.get(key);
    }

    @Override
    public int getReplicationScheduleValue() {
        return this.replicationSchedule_;
    }

    @Override
    public HybridReplicationSchedule getReplicationSchedule() {
        HybridReplicationSchedule result = HybridReplicationSchedule.forNumber(this.replicationSchedule_);
        return result == null ? HybridReplicationSchedule.UNRECOGNIZED : result;
    }

    @Override
    public int getHybridReplicationTypeValue() {
        return this.hybridReplicationType_;
    }

    @Override
    public VolumeHybridReplicationType getHybridReplicationType() {
        VolumeHybridReplicationType result = VolumeHybridReplicationType.forNumber(this.hybridReplicationType_);
        return result == null ? VolumeHybridReplicationType.UNRECOGNIZED : result;
    }

    @Override
    public int getLargeVolumeConstituentCount() {
        return this.largeVolumeConstituentCount_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.replication_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.replication_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerVolumeName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.peerVolumeName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerClusterName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.peerClusterName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerSvmName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.peerSvmName_);
        }
        for (int i = 0; i < this.peerIpAddresses_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.peerIpAddresses_.getRaw(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterLocation_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.clusterLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.description_);
        }
        GeneratedMessageV3.serializeStringMapTo((CodedOutputStream)output, this.internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, (int)8);
        if (this.replicationSchedule_ != HybridReplicationSchedule.HYBRID_REPLICATION_SCHEDULE_UNSPECIFIED.getNumber()) {
            output.writeEnum(9, this.replicationSchedule_);
        }
        if (this.hybridReplicationType_ != VolumeHybridReplicationType.VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.hybridReplicationType_);
        }
        if (this.largeVolumeConstituentCount_ != 0) {
            output.writeInt32(11, this.largeVolumeConstituentCount_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.replication_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.replication_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerVolumeName_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.peerVolumeName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerClusterName_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.peerClusterName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.peerSvmName_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.peerSvmName_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.peerIpAddresses_.size(); ++i) {
            dataSize += HybridReplicationParameters.computeStringSizeNoTag((Object)this.peerIpAddresses_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getPeerIpAddressesList().size();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.clusterLocation_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.clusterLocation_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.description_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.description_);
        }
        for (Map.Entry entry : this.internalGetLabels().getMap().entrySet()) {
            MapEntry labels__ = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType().setKey(entry.getKey()).setValue(entry.getValue()).build();
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)labels__);
        }
        if (this.replicationSchedule_ != HybridReplicationSchedule.HYBRID_REPLICATION_SCHEDULE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)9, (int)this.replicationSchedule_);
        }
        if (this.hybridReplicationType_ != VolumeHybridReplicationType.VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.hybridReplicationType_);
        }
        if (this.largeVolumeConstituentCount_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)11, (int)this.largeVolumeConstituentCount_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HybridReplicationParameters)) {
            return super.equals(obj);
        }
        HybridReplicationParameters other = (HybridReplicationParameters)obj;
        if (!this.getReplication().equals(other.getReplication())) {
            return false;
        }
        if (!this.getPeerVolumeName().equals(other.getPeerVolumeName())) {
            return false;
        }
        if (!this.getPeerClusterName().equals(other.getPeerClusterName())) {
            return false;
        }
        if (!this.getPeerSvmName().equals(other.getPeerSvmName())) {
            return false;
        }
        if (!this.getPeerIpAddressesList().equals(other.getPeerIpAddressesList())) {
            return false;
        }
        if (!this.getClusterLocation().equals(other.getClusterLocation())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.internalGetLabels().equals(other.internalGetLabels())) {
            return false;
        }
        if (this.replicationSchedule_ != other.replicationSchedule_) {
            return false;
        }
        if (this.hybridReplicationType_ != other.hybridReplicationType_) {
            return false;
        }
        if (this.getLargeVolumeConstituentCount() != other.getLargeVolumeConstituentCount()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + HybridReplicationParameters.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getReplication().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getPeerVolumeName().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getPeerClusterName().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getPeerSvmName().hashCode();
        if (this.getPeerIpAddressesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getPeerIpAddressesList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getClusterLocation().hashCode();
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getDescription().hashCode();
        if (!this.internalGetLabels().getMap().isEmpty()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.internalGetLabels().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.replicationSchedule_;
        hash = 37 * hash + 10;
        hash = 53 * hash + this.hybridReplicationType_;
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getLargeVolumeConstituentCount();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static HybridReplicationParameters parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data);
    }

    public static HybridReplicationParameters parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridReplicationParameters parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data);
    }

    public static HybridReplicationParameters parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridReplicationParameters parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data);
    }

    public static HybridReplicationParameters parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HybridReplicationParameters)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HybridReplicationParameters parseFrom(InputStream input) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static HybridReplicationParameters parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HybridReplicationParameters parseDelimitedFrom(InputStream input) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static HybridReplicationParameters parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HybridReplicationParameters parseFrom(CodedInputStream input) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static HybridReplicationParameters parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HybridReplicationParameters)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return HybridReplicationParameters.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HybridReplicationParameters prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static HybridReplicationParameters getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<HybridReplicationParameters> parser() {
        return PARSER;
    }

    public Parser<HybridReplicationParameters> getParserForType() {
        return PARSER;
    }

    public HybridReplicationParameters getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements HybridReplicationParametersOrBuilder {
        private int bitField0_;
        private Object replication_ = "";
        private Object peerVolumeName_ = "";
        private Object peerClusterName_ = "";
        private Object peerSvmName_ = "";
        private LazyStringArrayList peerIpAddresses_ = LazyStringArrayList.emptyList();
        private Object clusterLocation_ = "";
        private Object description_ = "";
        private MapField<String, String> labels_;
        private int replicationSchedule_ = 0;
        private int hybridReplicationType_ = 0;
        private int largeVolumeConstituentCount_;

        public static final Descriptors.Descriptor getDescriptor() {
            return VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_descriptor;
        }

        protected MapFieldReflectionAccessor internalGetMapFieldReflection(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected MapFieldReflectionAccessor internalGetMutableMapFieldReflection(int number) {
            switch (number) {
                case 8: {
                    return this.internalGetMutableLabels();
                }
            }
            throw new RuntimeException("Invalid map field number: " + number);
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_fieldAccessorTable.ensureFieldAccessorsInitialized(HybridReplicationParameters.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.replication_ = "";
            this.peerVolumeName_ = "";
            this.peerClusterName_ = "";
            this.peerSvmName_ = "";
            this.peerIpAddresses_ = LazyStringArrayList.emptyList();
            this.clusterLocation_ = "";
            this.description_ = "";
            this.internalGetMutableLabels().clear();
            this.replicationSchedule_ = 0;
            this.hybridReplicationType_ = 0;
            this.largeVolumeConstituentCount_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_descriptor;
        }

        public HybridReplicationParameters getDefaultInstanceForType() {
            return HybridReplicationParameters.getDefaultInstance();
        }

        public HybridReplicationParameters build() {
            HybridReplicationParameters result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public HybridReplicationParameters buildPartial() {
            HybridReplicationParameters result = new HybridReplicationParameters(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(HybridReplicationParameters result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.replication_ = this.replication_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.peerVolumeName_ = this.peerVolumeName_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.peerClusterName_ = this.peerClusterName_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.peerSvmName_ = this.peerSvmName_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                this.peerIpAddresses_.makeImmutable();
                result.peerIpAddresses_ = this.peerIpAddresses_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.clusterLocation_ = this.clusterLocation_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.description_ = this.description_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.labels_ = this.internalGetLabels();
                result.labels_.makeImmutable();
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.replicationSchedule_ = this.replicationSchedule_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.hybridReplicationType_ = this.hybridReplicationType_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.largeVolumeConstituentCount_ = this.largeVolumeConstituentCount_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof HybridReplicationParameters) {
                return this.mergeFrom((HybridReplicationParameters)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(HybridReplicationParameters other) {
            if (other == HybridReplicationParameters.getDefaultInstance()) {
                return this;
            }
            if (!other.getReplication().isEmpty()) {
                this.replication_ = other.replication_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getPeerVolumeName().isEmpty()) {
                this.peerVolumeName_ = other.peerVolumeName_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getPeerClusterName().isEmpty()) {
                this.peerClusterName_ = other.peerClusterName_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getPeerSvmName().isEmpty()) {
                this.peerSvmName_ = other.peerSvmName_;
                this.bitField0_ |= 8;
                this.onChanged();
            }
            if (!other.peerIpAddresses_.isEmpty()) {
                if (this.peerIpAddresses_.isEmpty()) {
                    this.peerIpAddresses_ = other.peerIpAddresses_;
                    this.bitField0_ |= 0x10;
                } else {
                    this.ensurePeerIpAddressesIsMutable();
                    this.peerIpAddresses_.addAll((Collection)other.peerIpAddresses_);
                }
                this.onChanged();
            }
            if (!other.getClusterLocation().isEmpty()) {
                this.clusterLocation_ = other.clusterLocation_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (!other.getDescription().isEmpty()) {
                this.description_ = other.description_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            this.internalGetMutableLabels().mergeFrom(other.internalGetLabels());
            this.bitField0_ |= 0x80;
            if (other.replicationSchedule_ != 0) {
                this.setReplicationScheduleValue(other.getReplicationScheduleValue());
            }
            if (other.hybridReplicationType_ != 0) {
                this.setHybridReplicationTypeValue(other.getHybridReplicationTypeValue());
            }
            if (other.getLargeVolumeConstituentCount() != 0) {
                this.setLargeVolumeConstituentCount(other.getLargeVolumeConstituentCount());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block19: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block19;
                        }
                        case 10: {
                            this.replication_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block19;
                        }
                        case 18: {
                            this.peerVolumeName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block19;
                        }
                        case 26: {
                            this.peerClusterName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block19;
                        }
                        case 34: {
                            this.peerSvmName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 8;
                            continue block19;
                        }
                        case 42: {
                            String s = input.readStringRequireUtf8();
                            this.ensurePeerIpAddressesIsMutable();
                            this.peerIpAddresses_.add((Object)s);
                            continue block19;
                        }
                        case 50: {
                            this.clusterLocation_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block19;
                        }
                        case 58: {
                            this.description_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block19;
                        }
                        case 66: {
                            MapEntry labels__ = (MapEntry)input.readMessage(LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                            this.internalGetMutableLabels().getMutableMap().put(labels__.getKey(), labels__.getValue());
                            this.bitField0_ |= 0x80;
                            continue block19;
                        }
                        case 72: {
                            this.replicationSchedule_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block19;
                        }
                        case 80: {
                            this.hybridReplicationType_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block19;
                        }
                        case 88: {
                            this.largeVolumeConstituentCount_ = input.readInt32();
                            this.bitField0_ |= 0x400;
                            continue block19;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getReplication() {
            Object ref = this.replication_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.replication_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getReplicationBytes() {
            Object ref = this.replication_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.replication_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setReplication(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.replication_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearReplication() {
            this.replication_ = HybridReplicationParameters.getDefaultInstance().getReplication();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setReplicationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.replication_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getPeerVolumeName() {
            Object ref = this.peerVolumeName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.peerVolumeName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPeerVolumeNameBytes() {
            Object ref = this.peerVolumeName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.peerVolumeName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPeerVolumeName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.peerVolumeName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearPeerVolumeName() {
            this.peerVolumeName_ = HybridReplicationParameters.getDefaultInstance().getPeerVolumeName();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setPeerVolumeNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.peerVolumeName_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getPeerClusterName() {
            Object ref = this.peerClusterName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.peerClusterName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPeerClusterNameBytes() {
            Object ref = this.peerClusterName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.peerClusterName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPeerClusterName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.peerClusterName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearPeerClusterName() {
            this.peerClusterName_ = HybridReplicationParameters.getDefaultInstance().getPeerClusterName();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setPeerClusterNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.peerClusterName_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public String getPeerSvmName() {
            Object ref = this.peerSvmName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.peerSvmName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPeerSvmNameBytes() {
            Object ref = this.peerSvmName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.peerSvmName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPeerSvmName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.peerSvmName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearPeerSvmName() {
            this.peerSvmName_ = HybridReplicationParameters.getDefaultInstance().getPeerSvmName();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        public Builder setPeerSvmNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.peerSvmName_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        private void ensurePeerIpAddressesIsMutable() {
            if (!this.peerIpAddresses_.isModifiable()) {
                this.peerIpAddresses_ = new LazyStringArrayList((LazyStringList)this.peerIpAddresses_);
            }
            this.bitField0_ |= 0x10;
        }

        public ProtocolStringList getPeerIpAddressesList() {
            this.peerIpAddresses_.makeImmutable();
            return this.peerIpAddresses_;
        }

        @Override
        public int getPeerIpAddressesCount() {
            return this.peerIpAddresses_.size();
        }

        @Override
        public String getPeerIpAddresses(int index) {
            return this.peerIpAddresses_.get(index);
        }

        @Override
        public ByteString getPeerIpAddressesBytes(int index) {
            return this.peerIpAddresses_.getByteString(index);
        }

        public Builder setPeerIpAddresses(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePeerIpAddressesIsMutable();
            this.peerIpAddresses_.set(index, value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addPeerIpAddresses(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensurePeerIpAddressesIsMutable();
            this.peerIpAddresses_.add((Object)value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder addAllPeerIpAddresses(Iterable<String> values) {
            this.ensurePeerIpAddressesIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.peerIpAddresses_);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearPeerIpAddresses() {
            this.peerIpAddresses_ = LazyStringArrayList.emptyList();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder addPeerIpAddressesBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.ensurePeerIpAddressesIsMutable();
            this.peerIpAddresses_.add(value);
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public String getClusterLocation() {
            Object ref = this.clusterLocation_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.clusterLocation_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getClusterLocationBytes() {
            Object ref = this.clusterLocation_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.clusterLocation_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setClusterLocation(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.clusterLocation_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearClusterLocation() {
            this.clusterLocation_ = HybridReplicationParameters.getDefaultInstance().getClusterLocation();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setClusterLocationBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.clusterLocation_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public String getDescription() {
            Object ref = this.description_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.description_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDescriptionBytes() {
            Object ref = this.description_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.description_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDescription(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.description_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearDescription() {
            this.description_ = HybridReplicationParameters.getDefaultInstance().getDescription();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setDescriptionBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            HybridReplicationParameters.checkByteStringIsUtf8((ByteString)value);
            this.description_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        private MapField<String, String> internalGetLabels() {
            if (this.labels_ == null) {
                return MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            return this.labels_;
        }

        private MapField<String, String> internalGetMutableLabels() {
            if (this.labels_ == null) {
                this.labels_ = MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
            }
            if (!this.labels_.isMutable()) {
                this.labels_ = this.labels_.copy();
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this.labels_;
        }

        @Override
        public int getLabelsCount() {
            return this.internalGetLabels().getMap().size();
        }

        @Override
        public boolean containsLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            return this.internalGetLabels().getMap().containsKey(key);
        }

        @Override
        @Deprecated
        public Map<String, String> getLabels() {
            return this.getLabelsMap();
        }

        @Override
        public Map<String, String> getLabelsMap() {
            return this.internalGetLabels().getMap();
        }

        @Override
        public String getLabelsOrDefault(String key, String defaultValue) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            return map.containsKey(key) ? (String)map.get(key) : defaultValue;
        }

        @Override
        public String getLabelsOrThrow(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            Map map = this.internalGetLabels().getMap();
            if (!map.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            return (String)map.get(key);
        }

        public Builder clearLabels() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.internalGetMutableLabels().getMutableMap().clear();
            return this;
        }

        public Builder removeLabels(String key) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            this.internalGetMutableLabels().getMutableMap().remove(key);
            return this;
        }

        @Deprecated
        public Map<String, String> getMutableLabels() {
            this.bitField0_ |= 0x80;
            return this.internalGetMutableLabels().getMutableMap();
        }

        public Builder putLabels(String key, String value) {
            if (key == null) {
                throw new NullPointerException("map key");
            }
            if (value == null) {
                throw new NullPointerException("map value");
            }
            this.internalGetMutableLabels().getMutableMap().put(key, value);
            this.bitField0_ |= 0x80;
            return this;
        }

        public Builder putAllLabels(Map<String, String> values) {
            this.internalGetMutableLabels().getMutableMap().putAll(values);
            this.bitField0_ |= 0x80;
            return this;
        }

        @Override
        public int getReplicationScheduleValue() {
            return this.replicationSchedule_;
        }

        public Builder setReplicationScheduleValue(int value) {
            this.replicationSchedule_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public HybridReplicationSchedule getReplicationSchedule() {
            HybridReplicationSchedule result = HybridReplicationSchedule.forNumber(this.replicationSchedule_);
            return result == null ? HybridReplicationSchedule.UNRECOGNIZED : result;
        }

        public Builder setReplicationSchedule(HybridReplicationSchedule value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.replicationSchedule_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReplicationSchedule() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.replicationSchedule_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getHybridReplicationTypeValue() {
            return this.hybridReplicationType_;
        }

        public Builder setHybridReplicationTypeValue(int value) {
            this.hybridReplicationType_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public VolumeHybridReplicationType getHybridReplicationType() {
            VolumeHybridReplicationType result = VolumeHybridReplicationType.forNumber(this.hybridReplicationType_);
            return result == null ? VolumeHybridReplicationType.UNRECOGNIZED : result;
        }

        public Builder setHybridReplicationType(VolumeHybridReplicationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.hybridReplicationType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearHybridReplicationType() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.hybridReplicationType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getLargeVolumeConstituentCount() {
            return this.largeVolumeConstituentCount_;
        }

        public Builder setLargeVolumeConstituentCount(int value) {
            this.largeVolumeConstituentCount_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearLargeVolumeConstituentCount() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.largeVolumeConstituentCount_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    private static final class LabelsDefaultEntryHolder {
        static final MapEntry<String, String> defaultEntry = MapEntry.newDefaultInstance((Descriptors.Descriptor)VolumeProto.internal_static_google_cloud_netapp_v1_HybridReplicationParameters_LabelsEntry_descriptor, (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"", (WireFormat.FieldType)WireFormat.FieldType.STRING, (Object)"");

        private LabelsDefaultEntryHolder() {
        }
    }

    public static enum VolumeHybridReplicationType implements ProtocolMessageEnum
    {
        VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED(0),
        MIGRATION(1),
        CONTINUOUS_REPLICATION(2),
        ONPREM_REPLICATION(3),
        REVERSE_ONPREM_REPLICATION(4),
        UNRECOGNIZED(-1);

        public static final int VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int MIGRATION_VALUE = 1;
        public static final int CONTINUOUS_REPLICATION_VALUE = 2;
        public static final int ONPREM_REPLICATION_VALUE = 3;
        public static final int REVERSE_ONPREM_REPLICATION_VALUE = 4;
        private static final Internal.EnumLiteMap<VolumeHybridReplicationType> internalValueMap;
        private static final VolumeHybridReplicationType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static VolumeHybridReplicationType valueOf(int value) {
            return VolumeHybridReplicationType.forNumber(value);
        }

        public static VolumeHybridReplicationType forNumber(int value) {
            switch (value) {
                case 0: {
                    return VOLUME_HYBRID_REPLICATION_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return MIGRATION;
                }
                case 2: {
                    return CONTINUOUS_REPLICATION;
                }
                case 3: {
                    return ONPREM_REPLICATION;
                }
                case 4: {
                    return REVERSE_ONPREM_REPLICATION;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<VolumeHybridReplicationType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)VolumeHybridReplicationType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return VolumeHybridReplicationType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)HybridReplicationParameters.getDescriptor().getEnumTypes().get(0);
        }

        public static VolumeHybridReplicationType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != VolumeHybridReplicationType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private VolumeHybridReplicationType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<VolumeHybridReplicationType>(){

                public VolumeHybridReplicationType findValueByNumber(int number) {
                    return VolumeHybridReplicationType.forNumber(number);
                }
            };
            VALUES = VolumeHybridReplicationType.values();
        }
    }
}

