/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReplicationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOLUME_REPLICATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/volumes/{volume}/replications/{replication}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String volume;
    private final String replication;

    @Deprecated
    protected ReplicationName() {
        this.project = null;
        this.location = null;
        this.volume = null;
        this.replication = null;
    }

    private ReplicationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.volume = (String)Preconditions.checkNotNull((Object)builder.getVolume());
        this.replication = (String)Preconditions.checkNotNull((Object)builder.getReplication());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getReplication() {
        return this.replication;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReplicationName of(String project, String location, String volume, String replication) {
        return ReplicationName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setReplication(replication).build();
    }

    public static String format(String project, String location, String volume, String replication) {
        return ReplicationName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setReplication(replication).build().toString();
    }

    public static ReplicationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOLUME_REPLICATION.validatedMatch(formattedString, "ReplicationName.parse: formattedString not in valid format");
        return ReplicationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("volume"), (String)matchMap.get("replication"));
    }

    public static List<ReplicationName> parseList(List<String> formattedStrings) {
        ArrayList<ReplicationName> list = new ArrayList<ReplicationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReplicationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReplicationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReplicationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOLUME_REPLICATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReplicationName replicationName = this;
            synchronized (replicationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.volume != null) {
                        fieldMapBuilder.put((Object)"volume", (Object)this.volume);
                    }
                    if (this.replication != null) {
                        fieldMapBuilder.put((Object)"replication", (Object)this.replication);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOLUME_REPLICATION.instantiate(new String[]{"project", this.project, "location", this.location, "volume", this.volume, "replication", this.replication});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReplicationName that = (ReplicationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.volume, that.volume) && Objects.equals(this.replication, that.replication);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.volume);
        h *= 1000003;
        return h ^= Objects.hashCode(this.replication);
    }

    public static class Builder {
        private String project;
        private String location;
        private String volume;
        private String replication;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getReplication() {
            return this.replication;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder setReplication(String replication) {
            this.replication = replication;
            return this;
        }

        private Builder(ReplicationName replicationName) {
            this.project = replicationName.project;
            this.location = replicationName.location;
            this.volume = replicationName.volume;
            this.replication = replicationName.replication;
        }

        public ReplicationName build() {
            return new ReplicationName(this);
        }
    }
}

