/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.netapp.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ActiveDirectoryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ACTIVE_DIRECTORY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/activeDirectories/{active_directory}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String activeDirectory;

    @Deprecated
    protected ActiveDirectoryName() {
        this.project = null;
        this.location = null;
        this.activeDirectory = null;
    }

    private ActiveDirectoryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.activeDirectory = (String)Preconditions.checkNotNull((Object)builder.getActiveDirectory());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getActiveDirectory() {
        return this.activeDirectory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ActiveDirectoryName of(String project, String location, String activeDirectory) {
        return ActiveDirectoryName.newBuilder().setProject(project).setLocation(location).setActiveDirectory(activeDirectory).build();
    }

    public static String format(String project, String location, String activeDirectory) {
        return ActiveDirectoryName.newBuilder().setProject(project).setLocation(location).setActiveDirectory(activeDirectory).build().toString();
    }

    public static ActiveDirectoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ACTIVE_DIRECTORY.validatedMatch(formattedString, "ActiveDirectoryName.parse: formattedString not in valid format");
        return ActiveDirectoryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("active_directory"));
    }

    public static List<ActiveDirectoryName> parseList(List<String> formattedStrings) {
        ArrayList<ActiveDirectoryName> list = new ArrayList<ActiveDirectoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ActiveDirectoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ActiveDirectoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ActiveDirectoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ACTIVE_DIRECTORY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ActiveDirectoryName activeDirectoryName = this;
            synchronized (activeDirectoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.activeDirectory != null) {
                        fieldMapBuilder.put((Object)"active_directory", (Object)this.activeDirectory);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ACTIVE_DIRECTORY.instantiate(new String[]{"project", this.project, "location", this.location, "active_directory", this.activeDirectory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ActiveDirectoryName that = (ActiveDirectoryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.activeDirectory, that.activeDirectory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.activeDirectory);
    }

    public static class Builder {
        private String project;
        private String location;
        private String activeDirectory;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getActiveDirectory() {
            return this.activeDirectory;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setActiveDirectory(String activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        private Builder(ActiveDirectoryName activeDirectoryName) {
            this.project = activeDirectoryName.project;
            this.location = activeDirectoryName.location;
            this.activeDirectory = activeDirectoryName.activeDirectory;
        }

        public ActiveDirectoryName build() {
            return new ActiveDirectoryName(this);
        }
    }
}

