/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPORT_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reportConfigs/{report_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reportConfig;

    @Deprecated
    protected ReportConfigName() {
        this.project = null;
        this.location = null;
        this.reportConfig = null;
    }

    private ReportConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reportConfig = (String)Preconditions.checkNotNull((Object)builder.getReportConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReportConfig() {
        return this.reportConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportConfigName of(String project, String location, String reportConfig) {
        return ReportConfigName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).build();
    }

    public static String format(String project, String location, String reportConfig) {
        return ReportConfigName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).build().toString();
    }

    public static ReportConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPORT_CONFIG.validatedMatch(formattedString, "ReportConfigName.parse: formattedString not in valid format");
        return ReportConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("report_config"));
    }

    public static List<ReportConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ReportConfigName> list = new ArrayList<ReportConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPORT_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportConfigName reportConfigName = this;
            synchronized (reportConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reportConfig != null) {
                        fieldMapBuilder.put((Object)"report_config", (Object)this.reportConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPORT_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "report_config", this.reportConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReportConfigName that = (ReportConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reportConfig, that.reportConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reportConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reportConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReportConfig() {
            return this.reportConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReportConfig(String reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        private Builder(ReportConfigName reportConfigName) {
            this.project = reportConfigName.project;
            this.location = reportConfigName.location;
            this.reportConfig = reportConfigName.reportConfig;
        }

        public ReportConfigName build() {
            return new ReportConfigName(this);
        }
    }
}

