/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPORT_CONFIG_REPORT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reportConfigs/{report_config}/reports/{report}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reportConfig;
    private final String report;

    @Deprecated
    protected ReportName() {
        this.project = null;
        this.location = null;
        this.reportConfig = null;
        this.report = null;
    }

    private ReportName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reportConfig = (String)Preconditions.checkNotNull((Object)builder.getReportConfig());
        this.report = (String)Preconditions.checkNotNull((Object)builder.getReport());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReportConfig() {
        return this.reportConfig;
    }

    public String getReport() {
        return this.report;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReportName of(String project, String location, String reportConfig, String report) {
        return ReportName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).setReport(report).build();
    }

    public static String format(String project, String location, String reportConfig, String report) {
        return ReportName.newBuilder().setProject(project).setLocation(location).setReportConfig(reportConfig).setReport(report).build().toString();
    }

    public static ReportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPORT_CONFIG_REPORT.validatedMatch(formattedString, "ReportName.parse: formattedString not in valid format");
        return ReportName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("report_config"), (String)matchMap.get("report"));
    }

    public static List<ReportName> parseList(List<String> formattedStrings) {
        ArrayList<ReportName> list = new ArrayList<ReportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPORT_CONFIG_REPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReportName reportName = this;
            synchronized (reportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reportConfig != null) {
                        fieldMapBuilder.put((Object)"report_config", (Object)this.reportConfig);
                    }
                    if (this.report != null) {
                        fieldMapBuilder.put((Object)"report", (Object)this.report);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPORT_CONFIG_REPORT.instantiate(new String[]{"project", this.project, "location", this.location, "report_config", this.reportConfig, "report", this.report});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ReportName that = (ReportName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reportConfig, that.reportConfig) && Objects.equals(this.report, that.report);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.reportConfig);
        h *= 1000003;
        return h ^= Objects.hashCode(this.report);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reportConfig;
        private String report;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReportConfig() {
            return this.reportConfig;
        }

        public String getReport() {
            return this.report;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReportConfig(String reportConfig) {
            this.reportConfig = reportConfig;
            return this;
        }

        public Builder setReport(String report) {
            this.report = report;
            return this;
        }

        private Builder(ReportName reportName) {
            this.project = reportName.project;
            this.location = reportName.location;
            this.reportConfig = reportName.reportConfig;
            this.report = reportName.report;
        }

        public ReportName build() {
            return new ReportName(this);
        }
    }
}

