/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.migrationcenter.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ErrorFrameName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SOURCE_ERROR_FRAME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sources/{source}/errorFrames/{error_frame}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String source;
    private final String errorFrame;

    @Deprecated
    protected ErrorFrameName() {
        this.project = null;
        this.location = null;
        this.source = null;
        this.errorFrame = null;
    }

    private ErrorFrameName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
        this.errorFrame = (String)Preconditions.checkNotNull((Object)builder.getErrorFrame());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSource() {
        return this.source;
    }

    public String getErrorFrame() {
        return this.errorFrame;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ErrorFrameName of(String project, String location, String source, String errorFrame) {
        return ErrorFrameName.newBuilder().setProject(project).setLocation(location).setSource(source).setErrorFrame(errorFrame).build();
    }

    public static String format(String project, String location, String source, String errorFrame) {
        return ErrorFrameName.newBuilder().setProject(project).setLocation(location).setSource(source).setErrorFrame(errorFrame).build().toString();
    }

    public static ErrorFrameName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SOURCE_ERROR_FRAME.validatedMatch(formattedString, "ErrorFrameName.parse: formattedString not in valid format");
        return ErrorFrameName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("source"), (String)matchMap.get("error_frame"));
    }

    public static List<ErrorFrameName> parseList(List<String> formattedStrings) {
        ArrayList<ErrorFrameName> list = new ArrayList<ErrorFrameName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ErrorFrameName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ErrorFrameName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ErrorFrameName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SOURCE_ERROR_FRAME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ErrorFrameName errorFrameName = this;
            synchronized (errorFrameName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    if (this.errorFrame != null) {
                        fieldMapBuilder.put((Object)"error_frame", (Object)this.errorFrame);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SOURCE_ERROR_FRAME.instantiate(new String[]{"project", this.project, "location", this.location, "source", this.source, "error_frame", this.errorFrame});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ErrorFrameName that = (ErrorFrameName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.source, that.source) && Objects.equals(this.errorFrame, that.errorFrame);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.source);
        h *= 1000003;
        return h ^= Objects.hashCode(this.errorFrame);
    }

    public static class Builder {
        private String project;
        private String location;
        private String source;
        private String errorFrame;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSource() {
            return this.source;
        }

        public String getErrorFrame() {
            return this.errorFrame;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        public Builder setErrorFrame(String errorFrame) {
            this.errorFrame = errorFrame;
            return this;
        }

        private Builder(ErrorFrameName errorFrameName) {
            this.project = errorFrameName.project;
            this.location = errorFrameName.location;
            this.source = errorFrameName.source;
            this.errorFrame = errorFrameName.errorFrame;
        }

        public ErrorFrameName build() {
            return new ErrorFrameName(this);
        }
    }
}

